package com.biz.crm.tpm.business.withholding.formula.local.repository;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.constant.CommonSelectConstant;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaMain;
import com.biz.crm.tpm.business.withholding.formula.local.mapper.WithholdingFormulaMainMapper;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaSelectDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 预提公式主表(WithholdingFormulaMain)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 20:07:07
 */
@Component
public class WithholdingFormulaMainRepository extends ServiceImpl<WithholdingFormulaMainMapper, WithholdingFormulaMain> {

  @Autowired
  private WithholdingFormulaMainMapper withholdingFormulaMainMapper;

   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param withholdingFormulaMain 实体对象
   * @return
   */
  public Page<WithholdingFormulaMainVo> findByConditions(Pageable pageable, WithholdingFormulaMainDto withholdingFormulaMain) {
    Page<WithholdingFormulaMainVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WithholdingFormulaMainVo> pageList = this.withholdingFormulaMainMapper.findByConditions(page, withholdingFormulaMain);
    return pageList;
  }

  public List<WithholdingFormulaMainVo> getWithholdingFormulaByWithholdingType(String withholdingType, String currentYearMonth) {
    return this.withholdingFormulaMainMapper.getWithholdingFormulaByWithholdingType(withholdingType, currentYearMonth);
  }

  public List<WithholdingFormulaMainVo> findForWithholdingDetail(String yearMonth, WithholdingFormulaMainDto dto) {
    return this.withholdingFormulaMainMapper.findForWithholdingDetail(yearMonth, dto);
  }

  public List<CommonSelectVo> getSummaryFormulaSelect(WithholdingFormulaSelectDto dto) {
      return this.withholdingFormulaMainMapper.getSummaryFormulaSelect(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
  }

  public WithholdingFormulaMain findByCode(String withholdingRuleCode) {
    return this.lambdaQuery().eq(WithholdingFormulaMain::getWithholdingFormulaCode,withholdingRuleCode).one();
  }

  public WithholdingFormulaMain findById(String id) {
    return this.lambdaQuery().eq(WithholdingFormulaMain::getId, id)
            .eq(WithholdingFormulaMain::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(WithholdingFormulaMain::getTenantCode, TenantUtils.getTenantCode())
            .one();
  }
}

