package com.biz.crm.tpm.business.withholding.formula.local.service.internal;



import com.biz.crm.tpm.business.withholding.formula.local.repository.WithholdingFormulaInfoRepository;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaInfo;
import com.biz.crm.tpm.business.withholding.formula.local.service.WithholdingFormulaInfoService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 预提公式表(WithholdingFormulaInfo)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 20:07:08
 */
@Service("withholdingFormulaInfoService")
public class WithholdingFormulaInfoServiceImpl implements WithholdingFormulaInfoService {

  @Autowired
  private WithholdingFormulaInfoRepository withholdingFormulaInfoRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param withholdingFormulaInfo 实体对象
   * @return
   */
  @Override
  public Page<WithholdingFormulaInfo> findByConditions(Pageable pageable, WithholdingFormulaInfo withholdingFormulaInfo) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(withholdingFormulaInfo)) {
      withholdingFormulaInfo = new WithholdingFormulaInfo();
    }
    return this.withholdingFormulaInfoRepository.findByConditions(pageable, withholdingFormulaInfo);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public WithholdingFormulaInfo findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.withholdingFormulaInfoRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param withholdingFormulaInfo 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public WithholdingFormulaInfo create(WithholdingFormulaInfo withholdingFormulaInfo) {
    this.createValidate(withholdingFormulaInfo);
    this.withholdingFormulaInfoRepository.saveOrUpdate(withholdingFormulaInfo);
    return withholdingFormulaInfo;
  }
  
  /**
   * 修改新据
   * @param withholdingFormulaInfo 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public WithholdingFormulaInfo update(WithholdingFormulaInfo withholdingFormulaInfo) {
    this.updateValidate(withholdingFormulaInfo);
    this.withholdingFormulaInfoRepository.saveOrUpdate(withholdingFormulaInfo);
    return withholdingFormulaInfo;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.withholdingFormulaInfoRepository.removeByIds(idList);
  }
  
  /**
   * 创建验证
   * @param withholdingFormulaInfo
   */
  private void createValidate(WithholdingFormulaInfo withholdingFormulaInfo) {
    Validate.notNull(withholdingFormulaInfo, "新增时，对象信息不能为空！");
	withholdingFormulaInfo.setId(null);
      Validate.notBlank(withholdingFormulaInfo.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormula(), "新增数据时，预提公式不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaCode(), "新增数据时，预提公式编码不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaCondition(), "新增数据时，预提公式条件不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaConditionName(), "新增数据时，预提公式条件（展示用）不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaName(), "新增数据时，预提公式（展示用）不能为空！");
   
  }
  
   /**
   * 修改验证
   * @param withholdingFormulaInfo
   */
  private void updateValidate(WithholdingFormulaInfo withholdingFormulaInfo) {
    Validate.notNull(withholdingFormulaInfo, "修改时，对象信息不能为空！");
      Validate.notBlank(withholdingFormulaInfo.getId(), "新增数据时，不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormula(), "新增数据时，预提公式不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaCode(), "新增数据时，预提公式编码不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaCondition(), "新增数据时，预提公式条件不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaConditionName(), "新增数据时，预提公式条件（展示用）不能为空！");
    Validate.notBlank(withholdingFormulaInfo.getWithholdingFormulaName(), "新增数据时，预提公式（展示用）不能为空！");
    
  }
}

