package com.biz.crm.tpm.business.withholding.formula.local.service.internal;


import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaInfo;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaMain;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaROrgEntity;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaRProductEntity;
import com.biz.crm.tpm.business.withholding.formula.local.repository.TpmWithholdingFormulaROrgRepository;
import com.biz.crm.tpm.business.withholding.formula.local.repository.WithholdingFormulaInfoRepository;
import com.biz.crm.tpm.business.withholding.formula.local.repository.WithholdingFormulaMainRepository;
import com.biz.crm.tpm.business.withholding.formula.local.repository.WithholdingFormulaRProductRepository;
import com.biz.crm.tpm.business.withholding.formula.local.util.TpmWithholdingFormulaUtil;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.*;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.log.WithholdingFormulaLogEventDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.event.log.WithholdingFormulaEventListener;
import com.biz.crm.tpm.business.withholding.formula.sdk.service.WithholdingFormulaMainService;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaInfoVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaROrgVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaRProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 预提公式主表(WithholdingFormulaMain)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 20:07:06
 */
@Service("withholdingFormulaMainService")
public class WithholdingFormulaMainServiceImpl implements WithholdingFormulaMainService {

  private static final String WITHHOLDING_FORMULA_PREFIX = "YTGS";
  @Autowired(required = false)
  private WithholdingFormulaMainRepository withholdingFormulaMainRepository;

  @Autowired(required = false)
  private WithholdingFormulaInfoRepository withholdingFormulaInfoRepository;

  @Autowired(required = false)
  private TpmWithholdingFormulaROrgRepository tpmWithholdingFormulaROrgRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Autowired(required = false)
  private TpmWithholdingFormulaUtil tpmWithholdingFormulaUtil;

  @Autowired(required = false)
  private WithholdingFormulaRProductRepository withholdingFormulaRProductRepository;
  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param withholdingFormulaMain 实体对象
   * @return
   */
  @Override
  public Page<WithholdingFormulaMainVo> findByConditions(Pageable pageable, WithholdingFormulaMainDto withholdingFormulaMain) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(withholdingFormulaMain)) {
      withholdingFormulaMain = new WithholdingFormulaMainDto();
    }
    return this.withholdingFormulaMainRepository.findByConditions(pageable, withholdingFormulaMain);
  }

  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public WithholdingFormulaMainVo findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    WithholdingFormulaMain withholdingFormulaMainEntity = this.withholdingFormulaMainRepository.findById(id);
    Validate.notNull(withholdingFormulaMainEntity,"未查询到预提配置信息");
    WithholdingFormulaMainVo withholdingFormulaMainVo = this.nebulaToolkitService.copyObjectByWhiteList(withholdingFormulaMainEntity, WithholdingFormulaMainVo.class, null, null);

    List<WithholdingFormulaROrgEntity> orgEntities = this.tpmWithholdingFormulaROrgRepository.lambdaQuery().eq(WithholdingFormulaROrgEntity::getWithholdingFormulaCode, withholdingFormulaMainVo.getWithholdingFormulaCode()).orderByAsc(WithholdingFormulaROrgEntity::getSalesOrgCode).list();
    if (!CollectionUtils.isEmpty(orgEntities)) {
      Collection<WithholdingFormulaROrgVo> orgVoList = this.nebulaToolkitService.copyCollectionByBlankList(orgEntities, WithholdingFormulaROrgEntity.class, WithholdingFormulaROrgVo.class, LinkedHashSet.class, ArrayList.class);
      withholdingFormulaMainVo.setOrgVoList((List<WithholdingFormulaROrgVo>) orgVoList);
    }

    List<WithholdingFormulaInfo> list = this.withholdingFormulaInfoRepository.lambdaQuery().eq(WithholdingFormulaInfo::getWithholdingFormulaCode, withholdingFormulaMainEntity.getWithholdingFormulaCode()).list();
    if(!CollectionUtils.isEmpty(list)){
      Collection<WithholdingFormulaInfoVo> withholdingFormulaInfoVos = this.nebulaToolkitService.copyCollectionByBlankList(list, WithholdingFormulaInfo.class, WithholdingFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class);
      withholdingFormulaMainVo.setWithholdingFormulaInfoVoList((List<WithholdingFormulaInfoVo>) withholdingFormulaInfoVos);
    }

    List<WithholdingFormulaRProductEntity> productList = this.withholdingFormulaRProductRepository.lambdaQuery().eq(WithholdingFormulaRProductEntity::getWithholdingFormulaCode, withholdingFormulaMainEntity.getWithholdingFormulaCode()).list();
    if(!CollectionUtils.isEmpty(productList)){
      withholdingFormulaMainVo.setProductVoList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(productList, WithholdingFormulaRProductEntity.class, WithholdingFormulaRProductVo.class, LinkedHashSet.class, ArrayList.class)));
    }
    return withholdingFormulaMainVo;
  }

  /**
   * 新增数据
   * @param withholdingFormulaMain 实体对象
   * @return 新增结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void create(WithholdingFormulaMainDto withholdingFormulaMain) {
//todo    this.createValidate(withholdingFormulaMain);
    tpmWithholdingFormulaUtil.check(withholdingFormulaMain);
    tpmWithholdingFormulaUtil.checkOrg(withholdingFormulaMain);
//    String ruleCode = StringUtils.join(WITHHOLDING_FORMULA_PREFIX, DateFormatUtils.format(new Date(), "yyyyMMdd"));
    String code = this.generateCodeService.generateCode(WITHHOLDING_FORMULA_PREFIX, 1, 5, 0, TimeUnit.DAYS).get(0);
    withholdingFormulaMain.setWithholdingFormulaCode(code);
    WithholdingFormulaMain withholdingFormulaMainEntity = this.nebulaToolkitService.copyObjectByWhiteList(withholdingFormulaMain, WithholdingFormulaMain.class, null, null);
    withholdingFormulaMainEntity.setTenantCode(TenantUtils.getTenantCode());
    withholdingFormulaMainEntity.setId(null);
    this.withholdingFormulaMainRepository.saveOrUpdate(withholdingFormulaMainEntity);

    // 如果有自定义配置的核销变量也要保存
    this.saveCriterionConfig(withholdingFormulaMain);

    List<WithholdingFormulaROrgDto> orgVoList = withholdingFormulaMain.getOrgVoList();
    if(!CollectionUtils.isEmpty(orgVoList)){
      orgVoList.forEach(item->{
        item.setWithholdingFormulaCode(withholdingFormulaMain.getWithholdingFormulaCode());
        item.setTenantCode(TenantUtils.getTenantCode());
        item.setId(null);
      });
      Collection<WithholdingFormulaROrgEntity> orgEntities = this.nebulaToolkitService.copyCollectionByBlankList(orgVoList, WithholdingFormulaROrgDto.class, WithholdingFormulaROrgEntity.class, LinkedHashSet.class, ArrayList.class);
      this.tpmWithholdingFormulaROrgRepository.saveBatch(orgEntities);
    }

    List<WithholdingFormulaRProductDto> productDtoList = withholdingFormulaMain.getProductDtoList();
    if(!CollectionUtils.isEmpty(productDtoList)){
      productDtoList.forEach(item->{
        item.setWithholdingFormulaCode(withholdingFormulaMain.getWithholdingFormulaCode());
        item.setTenantCode(TenantUtils.getTenantCode());
        item.setId(null);
      });
      Collection<WithholdingFormulaRProductEntity> productEntities = this.nebulaToolkitService.copyCollectionByBlankList(productDtoList, WithholdingFormulaRProductDto.class, WithholdingFormulaRProductEntity.class, LinkedHashSet.class, ArrayList.class);
      this.withholdingFormulaRProductRepository.saveBatch(productEntities);
    }

    List<WithholdingFormulaInfoDto> withholdingFormulaInfoDtoList = withholdingFormulaMain.getWithholdingFormulaInfoDtoList();
    if(!CollectionUtils.isEmpty(withholdingFormulaInfoDtoList)){
      withholdingFormulaInfoDtoList.forEach(item->{
        item.setWithholdingFormulaCode(withholdingFormulaMain.getWithholdingFormulaCode());
        item.setTenantCode(TenantUtils.getTenantCode());
        item.setId(null);
      });
      Collection<WithholdingFormulaInfo> withholdingFormulaInfos = this.nebulaToolkitService.copyCollectionByBlankList(withholdingFormulaInfoDtoList, WithholdingFormulaInfoDto.class, WithholdingFormulaInfo.class, LinkedHashSet.class, ArrayList.class);
      this.withholdingFormulaInfoRepository.saveBatch(withholdingFormulaInfos);
    }

    //新增业务日志
    WithholdingFormulaLogEventDto logEventDto = new WithholdingFormulaLogEventDto();
    logEventDto.setOriginal(null);
    logEventDto.setNewest(withholdingFormulaMain);
    SerializableBiConsumer<WithholdingFormulaEventListener, WithholdingFormulaLogEventDto> onCreate =
            WithholdingFormulaEventListener::onCreate;
    this.nebulaNetEventClient.publish(logEventDto, WithholdingFormulaEventListener.class, onCreate);

  }

  private void saveCriterionConfig(WithholdingFormulaMainDto withholdingFormulaMain) {

  }

  /**
   * 修改新据
   * @param withholdingFormulaMain 实体对象
   * @return 修改结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void update(WithholdingFormulaMainDto withholdingFormulaMain) {
//todo    this.updateValidate(withholdingFormulaMain);
    tpmWithholdingFormulaUtil.check(withholdingFormulaMain);
    tpmWithholdingFormulaUtil.checkOrg(withholdingFormulaMain);
    WithholdingFormulaMainVo oldVo = this.findById(withholdingFormulaMain.getId());
    WithholdingFormulaMain withholdingFormulaMainEntity = this.nebulaToolkitService.copyObjectByWhiteList(withholdingFormulaMain, WithholdingFormulaMain.class, null, null);
    withholdingFormulaMainEntity.setTenantCode(TenantUtils.getTenantCode());
    this.withholdingFormulaMainRepository.saveOrUpdate(withholdingFormulaMainEntity);

    // 如果有自定义配置的返利变量也要修改
    this.updateCriterionConfig(withholdingFormulaMain);

    this.tpmWithholdingFormulaROrgRepository.remove(Wrappers.lambdaUpdate(WithholdingFormulaROrgEntity.class).eq(WithholdingFormulaROrgEntity::getWithholdingFormulaCode,withholdingFormulaMain.getWithholdingFormulaCode()));
    List<WithholdingFormulaROrgDto> orgVoList = withholdingFormulaMain.getOrgVoList();
    if(!CollectionUtils.isEmpty(orgVoList)){
      orgVoList.forEach(item->{
        item.setWithholdingFormulaCode(withholdingFormulaMain.getWithholdingFormulaCode());
        item.setTenantCode(TenantUtils.getTenantCode());
        item.setId(null);
      });
      Collection<WithholdingFormulaROrgEntity> orgEntities = this.nebulaToolkitService.copyCollectionByBlankList(orgVoList, WithholdingFormulaROrgDto.class, WithholdingFormulaROrgEntity.class, LinkedHashSet.class, ArrayList.class);
      this.tpmWithholdingFormulaROrgRepository.saveBatch(orgEntities);
    }

    this.withholdingFormulaRProductRepository.remove(Wrappers.lambdaUpdate(WithholdingFormulaRProductEntity.class).eq(WithholdingFormulaRProductEntity::getWithholdingFormulaCode,withholdingFormulaMain.getWithholdingFormulaCode()));
    List<WithholdingFormulaRProductDto> productDtoList = withholdingFormulaMain.getProductDtoList();
    if(!CollectionUtils.isEmpty(productDtoList)){
      productDtoList.forEach(item->{
        item.setWithholdingFormulaCode(withholdingFormulaMain.getWithholdingFormulaCode());
        item.setTenantCode(TenantUtils.getTenantCode());
        item.setId(null);
      });
      Collection<WithholdingFormulaRProductEntity> productEntities = this.nebulaToolkitService.copyCollectionByBlankList(productDtoList, WithholdingFormulaRProductDto.class, WithholdingFormulaRProductEntity.class, LinkedHashSet.class, ArrayList.class);
      this.withholdingFormulaRProductRepository.saveBatch(productEntities);
    }

    //更新公式
    this.withholdingFormulaInfoRepository.remove(Wrappers.lambdaUpdate(WithholdingFormulaInfo.class).eq(WithholdingFormulaInfo::getWithholdingFormulaCode,withholdingFormulaMain.getWithholdingFormulaCode()));
    List<WithholdingFormulaInfoDto> withholdingFormulaInfoDtoList = withholdingFormulaMain.getWithholdingFormulaInfoDtoList();
    if(!CollectionUtils.isEmpty(withholdingFormulaInfoDtoList)){
      withholdingFormulaInfoDtoList.forEach(item->{
        item.setWithholdingFormulaCode(withholdingFormulaMain.getWithholdingFormulaCode());
        item.setTenantCode(TenantUtils.getTenantCode());
      });
      Collection<WithholdingFormulaInfo> withholdingFormulaInfos = this.nebulaToolkitService.copyCollectionByBlankList(withholdingFormulaInfoDtoList, WithholdingFormulaInfoDto.class, WithholdingFormulaInfo.class, LinkedHashSet.class, ArrayList.class);
      withholdingFormulaInfos.forEach(item->{
        item.setId(null);
      });
      this.withholdingFormulaInfoRepository.saveBatch(withholdingFormulaInfos);
    }

    //更新业务日志
    WithholdingFormulaLogEventDto logEventDto = new WithholdingFormulaLogEventDto();
    logEventDto.setOriginal(oldVo);
    logEventDto.setNewest(withholdingFormulaMain);
    SerializableBiConsumer<WithholdingFormulaEventListener, WithholdingFormulaLogEventDto> onUpdate =
            WithholdingFormulaEventListener::onUpdate;
    this.nebulaNetEventClient.publish(logEventDto, WithholdingFormulaEventListener.class, onUpdate);
  }

  private void updateCriterionConfig(WithholdingFormulaMainDto withholdingFormulaMain) {

  }

  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    List<WithholdingFormulaMain> withholdingFormulaMainList1 = this.withholdingFormulaMainRepository.listByIds(idList);
    Validate.isTrue(!CollectionUtils.isEmpty(withholdingFormulaMainList1),"删除时数据不能为空");
    List<WithholdingFormulaMain> withholdingFormulaMainList = new ArrayList<>();
    List<WithholdingFormulaLogEventDto> withholdingFormulaLogEventDtoList = new ArrayList<>();
    withholdingFormulaMainList1.forEach(item->{
      Validate.isTrue(StringUtils.equals(EnableStatusEnum.DISABLE.getCode(),item.getEnableStatus()),
              "预提规则[%s]启用中，暂不支持删除！", item.getWithholdingFormulaCode());
      WithholdingFormulaMain withholdingFormulaMain = new WithholdingFormulaMain();
      withholdingFormulaMain.setId(item.getId());
      withholdingFormulaMain.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
      withholdingFormulaMainList.add(withholdingFormulaMain);

      //删除业务日志
      WithholdingFormulaLogEventDto logEventDto = new WithholdingFormulaLogEventDto();
      WithholdingFormulaMainVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingFormulaMainVo.class, null, null);
      logEventDto.setOriginal(oldVo);
      WithholdingFormulaMainDto withholdingFormulaMainDto = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingFormulaMainDto.class, null, null);
      withholdingFormulaMainDto.setDelFlag(withholdingFormulaMain.getDelFlag());
      logEventDto.setNewest(withholdingFormulaMainDto);
      withholdingFormulaLogEventDtoList.add(logEventDto);
    });
    SerializableBiConsumer<WithholdingFormulaEventListener, WithholdingFormulaLogEventDto> onDelete =
            WithholdingFormulaEventListener::onDelete;
    withholdingFormulaLogEventDtoList.forEach(log->{
      this.nebulaNetEventClient.publish(log, WithholdingFormulaEventListener.class, onDelete);
    });
    this.withholdingFormulaMainRepository.updateBatchById(withholdingFormulaMainList);
  }

  @Override
  public void enable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
    List<WithholdingFormulaMain> withholdingFormulaMainList1 = this.withholdingFormulaMainRepository.listByIds(idList);
    Validate.isTrue(!CollectionUtils.isEmpty(withholdingFormulaMainList1),"启用时数据不能为空");
    List<WithholdingFormulaMain> withholdingFormulaMainList = new ArrayList<>();
    withholdingFormulaMainList1.forEach(item->{
      WithholdingFormulaMain withholdingFormulaMain = new WithholdingFormulaMain();
      withholdingFormulaMain.setId(item.getId());
      withholdingFormulaMain.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      withholdingFormulaMainList.add(withholdingFormulaMain);

      //启用业务日志
      WithholdingFormulaLogEventDto logEventDto = new WithholdingFormulaLogEventDto();
      WithholdingFormulaMainVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingFormulaMainVo.class, null, null);
      logEventDto.setOriginal(oldVo);
      WithholdingFormulaMainDto withholdingFormulaMainDto = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingFormulaMainDto.class, null, null);
      withholdingFormulaMainDto.setEnableStatus(withholdingFormulaMain.getEnableStatus());
      logEventDto.setNewest(withholdingFormulaMainDto);
      SerializableBiConsumer<WithholdingFormulaEventListener, WithholdingFormulaLogEventDto> onEnable =
              WithholdingFormulaEventListener::onEnable;
      this.nebulaNetEventClient.publish(logEventDto, WithholdingFormulaEventListener.class, onEnable);
    });
    this.withholdingFormulaMainRepository.updateBatchById(withholdingFormulaMainList);
  }

  @Override
  public void disable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
    List<WithholdingFormulaMain> withholdingFormulaMainList1 = this.withholdingFormulaMainRepository.listByIds(idList);
    Validate.isTrue(!CollectionUtils.isEmpty(withholdingFormulaMainList1),"禁用时数据不能为空");
    List<WithholdingFormulaMain> withholdingFormulaMainList = new ArrayList<>();
    withholdingFormulaMainList1.forEach(item->{
      WithholdingFormulaMain withholdingFormulaMain = new WithholdingFormulaMain();
      withholdingFormulaMain.setId(item.getId());
      withholdingFormulaMain.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
      withholdingFormulaMainList.add(withholdingFormulaMain);

      //禁用业务日志
      WithholdingFormulaLogEventDto logEventDto = new WithholdingFormulaLogEventDto();
      WithholdingFormulaMainVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingFormulaMainVo.class, null, null);
      logEventDto.setOriginal(oldVo);
      WithholdingFormulaMainDto withholdingFormulaMainDto = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingFormulaMainDto.class, null, null);
      withholdingFormulaMainDto.setEnableStatus(withholdingFormulaMain.getEnableStatus());
      logEventDto.setNewest(withholdingFormulaMainDto);
      SerializableBiConsumer<WithholdingFormulaEventListener, WithholdingFormulaLogEventDto> onDisable =
              WithholdingFormulaEventListener::onDisable;
      this.nebulaNetEventClient.publish(logEventDto, WithholdingFormulaEventListener.class, onDisable);
    });
    this.withholdingFormulaMainRepository.updateBatchById(withholdingFormulaMainList);
  }

  @Override
  public List<WithholdingFormulaMainVo> getWithholdingFormulaByWithholdingType(String withholdingType) {
    String currentYearMonth = DateUtil.format(new Date(), "yyyy-MM");
    return this.withholdingFormulaMainRepository.getWithholdingFormulaByWithholdingType(withholdingType, currentYearMonth);
  }

  @Override
  public List<WithholdingFormulaMainVo> findForWithholdingDetail(WithholdingFormulaMainDto dto) {
    String currentYearMonth = DateUtil.format(new Date(), "yyyy-MM");
    List<WithholdingFormulaMainVo> mainList = withholdingFormulaMainRepository.findForWithholdingDetail(currentYearMonth, dto);
    List<String> mainCodeList = mainList.stream().map(WithholdingFormulaMainVo::getWithholdingFormulaCode).collect(Collectors.toList());
    List<WithholdingFormulaInfoVo> infoList = this.withholdingFormulaInfoRepository.findInfoByMainCodeList(mainCodeList);
    //封装数据
    Map<String, List<WithholdingFormulaInfoVo>> withholdingFormulaInfoMap = infoList.stream().collect(Collectors.groupingBy(WithholdingFormulaInfoVo::getWithholdingFormulaCode));
    for(WithholdingFormulaMainVo mainVo : mainList){
      mainVo.setWithholdingFormulaInfoVoList(withholdingFormulaInfoMap.get(mainVo.getWithholdingFormulaCode()));
    }
    return mainList;
  }

  @Override
  public List<CommonSelectVo> getSummaryFormulaSelect(WithholdingFormulaSelectDto dto) {
    if (Objects.isNull(dto)) {
      dto = new WithholdingFormulaSelectDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.withholdingFormulaMainRepository.getSummaryFormulaSelect(dto);
  }

  @Override
  public WithholdingFormulaMainVo findByCode(String withholdingRuleCode) {
    WithholdingFormulaMain withholdingFormulaMain = this.withholdingFormulaMainRepository.findByCode(withholdingRuleCode);
    List<String> withholdingFormulaCodeList = new ArrayList<>();
    withholdingFormulaCodeList.add(withholdingRuleCode);
    List<WithholdingFormulaInfoVo> infoList = this.withholdingFormulaInfoRepository.findInfoByMainCodeList(withholdingFormulaCodeList);
    WithholdingFormulaMainVo mainVo = nebulaToolkitService.copyObjectByWhiteList(withholdingFormulaMain, WithholdingFormulaMainVo.class, LinkedHashSet.class, ArrayList.class);
    mainVo.setWithholdingFormulaInfoVoList(infoList);

    List<WithholdingFormulaROrgEntity> orgEntities = this.tpmWithholdingFormulaROrgRepository.lambdaQuery().eq(WithholdingFormulaROrgEntity::getWithholdingFormulaCode, withholdingFormulaMain.getWithholdingFormulaCode()).orderByAsc(WithholdingFormulaROrgEntity::getSalesOrgCode).list();
    if (!CollectionUtils.isEmpty(orgEntities)) {
      Collection<WithholdingFormulaROrgVo> orgVoList = this.nebulaToolkitService.copyCollectionByBlankList(orgEntities, WithholdingFormulaROrgEntity.class, WithholdingFormulaROrgVo.class, LinkedHashSet.class, ArrayList.class);
      mainVo.setOrgVoList((List<WithholdingFormulaROrgVo>) orgVoList);
    }

    List<WithholdingFormulaRProductEntity> productList = this.withholdingFormulaRProductRepository.lambdaQuery().eq(WithholdingFormulaRProductEntity::getWithholdingFormulaCode, withholdingFormulaMain.getWithholdingFormulaCode()).list();
    if(!CollectionUtils.isEmpty(productList)){
      mainVo.setProductVoList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(productList, WithholdingFormulaRProductEntity.class, WithholdingFormulaRProductVo.class, LinkedHashSet.class, ArrayList.class)));
    }
    return mainVo;
  }

  /**
   * 创建验证
   * @param withholdingFormulaMain
   */
  private void createValidate(WithholdingFormulaMain withholdingFormulaMain) {
    Validate.notNull(withholdingFormulaMain, "新增时，对象信息不能为空！");
	withholdingFormulaMain.setId(null);
      Validate.notBlank(withholdingFormulaMain.getTenantCode(), "新增数据时，租户编号不能为空！");

  }

   /**
   * 修改验证
   * @param withholdingFormulaMain
   */
  private void updateValidate(WithholdingFormulaMainDto withholdingFormulaMain) {
    Validate.notNull(withholdingFormulaMain, "修改时，对象信息不能为空！");
      Validate.notBlank(withholdingFormulaMain.getId(), "新增数据时，不能为空！");
    Validate.notBlank(withholdingFormulaMain.getTenantCode(), "新增数据时，租户编号不能为空！");

  }
}

