package com.biz.crm.tpm.business.withholding.formula.local.util;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.constant.YesOrNoEnum;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaROrgDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-23
 */
@Component
public class TpmWithholdingFormulaUtil {

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    /**
     * 销售组织验证-必需选同一销售机构下的
     * 把销售机构erp编码写到规则头上的salesOrgCode字段
     *
     * @param withholdingFormulaMain
     */
    public void checkOrg(WithholdingFormulaMainDto withholdingFormulaMain) {
        Validate.notNull(withholdingFormulaMain.getOrgVoList(), "请选择销售组织！");
        List<String> orgCodeList = new ArrayList<>();
        withholdingFormulaMain.getOrgVoList().forEach(v -> {
            Validate.notBlank(v.getSalesOrgCode(), "销售组织编码为空！");
            orgCodeList.add(v.getSalesOrgCode());
        });
        List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodes(orgCodeList);
        Validate.notEmpty(salesOrgVoList, "销售组织信息不存在或未启用！");
        Map<String, SalesOrgVo> map = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, v -> v));

        String erpCode = null;
        for (WithholdingFormulaROrgDto v : withholdingFormulaMain.getOrgVoList()) {
            Validate.isTrue(map.containsKey(v.getSalesOrgCode()), "销售组织编码[%s]信息不存在或未启用！", v.getSalesOrgCode());
            SalesOrgVo salesOrgVo = map.get(v.getSalesOrgCode());
            Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(salesOrgVo.getEnableStatus()), "销售组织编码[%s]信息未启用！", v.getSalesOrgCode());
            Validate.isTrue(DelFlagStatusEnum.NORMAL.getCode().equals(salesOrgVo.getDelFlag()), "销售组织编码[%s]信息不存在！", v.getSalesOrgCode());

            if (StringUtils.isEmpty(erpCode)) {
                erpCode = salesOrgVo.getErpCode();
            } else {
                Validate.isTrue(StringUtils.equals(erpCode, salesOrgVo.getErpCode()), "只能选择同一销售机构及其下面的销售组织！");
            }
        }
        withholdingFormulaMain.setSalesOrgCode(erpCode);
    }

    public void check(WithholdingFormulaMainDto withholdingFormulaMainDto) {
        if (YesOrNoEnum.YES.getCode().equals(withholdingFormulaMainDto.getDiffActivityType())) {
            Validate.notBlank(withholdingFormulaMainDto.getContractCode(), "合同编码不能为空！");
            Validate.notBlank(withholdingFormulaMainDto.getContractName(), "合同名称不能为空！");
        } else {
            withholdingFormulaMainDto.setContractCode("");
            withholdingFormulaMainDto.setContractName("");
        }
    }
}
