/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.formula.local.util;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.constant.YesOrNoEnum;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaROrgDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmWithholdingFormulaUtil {
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public void checkOrg(WithholdingFormulaMainDto withholdingFormulaMain) {
        Validate.notNull((Object)withholdingFormulaMain.getOrgVoList(), (String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\uff01", (Object[])new Object[0]);
        ArrayList orgCodeList = new ArrayList();
        withholdingFormulaMain.getOrgVoList().forEach(v -> {
            Validate.notBlank((CharSequence)v.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            orgCodeList.add(v.getSalesOrgCode());
        });
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(orgCodeList);
        Validate.notEmpty((Collection)salesOrgVoList, (String)"\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01", (Object[])new Object[0]);
        Map<String, SalesOrgVo> map = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, v -> v));
        String erpCode = null;
        for (WithholdingFormulaROrgDto v2 : withholdingFormulaMain.getOrgVoList()) {
            Validate.isTrue((boolean)map.containsKey(v2.getSalesOrgCode()), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[%s]\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01", (Object[])new Object[]{v2.getSalesOrgCode()});
            SalesOrgVo salesOrgVo = map.get(v2.getSalesOrgCode());
            Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(salesOrgVo.getEnableStatus()), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[%s]\u4fe1\u606f\u672a\u542f\u7528\uff01", (Object[])new Object[]{v2.getSalesOrgCode()});
            Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(salesOrgVo.getDelFlag()), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[%s]\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{v2.getSalesOrgCode()});
            if (StringUtils.isEmpty(erpCode)) {
                erpCode = salesOrgVo.getErpCode();
                continue;
            }
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)erpCode, (CharSequence)salesOrgVo.getErpCode()), (String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u9500\u552e\u673a\u6784\u53ca\u5176\u4e0b\u9762\u7684\u9500\u552e\u7ec4\u7ec7\uff01", (Object[])new Object[0]);
        }
        withholdingFormulaMain.setSalesOrgCode(erpCode);
    }

    public void check(WithholdingFormulaMainDto withholdingFormulaMainDto) {
        if (YesOrNoEnum.YES.getCode().equals(withholdingFormulaMainDto.getDiffActivityType())) {
            Validate.notBlank((CharSequence)withholdingFormulaMainDto.getContractCode(), (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)withholdingFormulaMainDto.getContractName(), (String)"\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else {
            withholdingFormulaMainDto.setContractCode("");
            withholdingFormulaMainDto.setContractName("");
        }
    }
}

