package com.biz.crm.tpm.business.year.add.data.contrast.report.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.year.add.data.contrast.report.sdk.dto.YearAddDataContrastReportDto;
import com.biz.crm.tpm.business.year.add.data.contrast.report.sdk.service.YearAddDataContrastReportService;
import com.biz.crm.tpm.business.year.add.data.contrast.report.sdk.vo.YearAddDataContrastReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/14 14:55
 * @description：年度数据对比表
 */
@RestController
@RequestMapping("/v1/yearAddDataContrastReport")
@Slf4j
@Api(tags = "商务政策主表")
public class YearAddDataContrastReportController {

    @Autowired
    private YearAddDataContrastReportService yearAddDataContrastReportService;
    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param businessPolicy 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<YearAddDataContrastReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "businessPolicy", value = "商务政策主表") YearAddDataContrastReportDto dto) {
        try {
            Page<YearAddDataContrastReportVo> page =  this.yearAddDataContrastReportService.findByConditions(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
