package com.biz.crm.workflow.register;

import com.biz.crm.workflow.local.service.ProcessDelegateConfigDetailService;
import com.biz.crm.workflow.local.service.ProcessDelegateMandataryConfigDetailService;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigDetailVo;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateMandataryConfigDetailVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 配置补充参数
 *
 * @author : rentao
 * @date : 2022/11/29 16:25
 */
@Component
public class ProcessDelegateConfigExternalQueryInterceptor implements ExternalQueryInterceptor {

  @Autowired
  public ProcessDelegateConfigDetailService processDelegateConfigDetailService;
  @Autowired
  public ProcessDelegateMandataryConfigDetailService processDelegateMandataryConfigDetailService;

  @Override
  public String code() {
    return "processDelegateConfigExternalQueryInterceptor";
  }

  @Override
  public String name() {
    return "bpm委托配置-参数补充";
  }

  @Override
  public List<Object[]> process(EntityManager currentEntityManager, MetaData metadata, EuropaInfoVo europaInfoVo, ExecuteContent queryContent, String... fieldNames) {
    List<Map<String, Object>> results = queryContent.getResults();
    if (CollectionUtils.isEmpty(results)) {
      return null;
    }
    if (0 == results.parallelStream().filter(row -> row != null).count()) {
      return Lists.newArrayList();
    }
    Set<String> ids = Sets.newHashSet();
    results.forEach(result -> {
      ids.add((String) result.get("id"));
    });
    //委托人
    List<ProcessDelegateConfigDetailVo> processDelegateConfigDetailVos = this.processDelegateConfigDetailService.findByConfigIds(ids);
    //被委托人
    List<ProcessDelegateMandataryConfigDetailVo> processDelegateMandataryConfigDetailVoList = this.processDelegateMandataryConfigDetailService.findByConfigIds(ids);

    Map<String, List<ProcessDelegateConfigDetailVo>> configDetailVoMap = new HashMap<>();

    Map<String, List<ProcessDelegateMandataryConfigDetailVo>> mandataryConfigDetailVoMap = new HashMap<>();

    if (!CollectionUtils.isEmpty(processDelegateConfigDetailVos)) {
      Map<String, List<ProcessDelegateConfigDetailVo>> collect = processDelegateConfigDetailVos.stream().collect(Collectors.groupingBy(logsVo -> logsVo.getProcessDelegateConfigId()));
      configDetailVoMap.putAll(collect);
    }
    if (!CollectionUtils.isEmpty(processDelegateMandataryConfigDetailVoList)) {
      Map<String, List<ProcessDelegateMandataryConfigDetailVo>> collect = processDelegateMandataryConfigDetailVoList.stream().collect(Collectors.groupingBy(logsVo -> logsVo.getProcessDelegateConfigId()));
      mandataryConfigDetailVoMap.putAll(collect);
    }
    List<Object[]> externalContents = Lists.newArrayList();
    for (Map<String, Object> resutl : results) {
      List<Object> itemList = Lists.newArrayList();
      String id = (String) resutl.get("id");
      List<ProcessDelegateConfigDetailVo> processDelegateConfigDetailVoList = configDetailVoMap.get(id);
      List<ProcessDelegateMandataryConfigDetailVo> mandataryConfigDetailVos = mandataryConfigDetailVoMap.get(id);
      for (String externalFieldName : fieldNames) {
        //
        if (StringUtils.equals(externalFieldName, "delegate_name")) {
          if (!CollectionUtils.isEmpty(processDelegateConfigDetailVoList)) {
            List<String> userNames = processDelegateConfigDetailVoList.stream().map(ProcessDelegateConfigDetailVo::getName).collect(Collectors.toList());
            itemList.add(Optional.ofNullable(userNames.toString()));
          } else {
            itemList.add("");
          }
        }
        //
        else if (StringUtils.equals(externalFieldName, "mandatary_name")) {
          if (!CollectionUtils.isEmpty(mandataryConfigDetailVos)) {
            List<String> userNames = mandataryConfigDetailVos.stream().map(ProcessDelegateMandataryConfigDetailVo::getName).collect(Collectors.toList());
            itemList.add(Optional.ofNullable(userNames.toString()));
          } else {
            itemList.add("");
          }
        }
      }
      externalContents.add(itemList.toArray(new Object[]{}));
    }
    return externalContents;
  }
}
