package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>流程已办数据视图注册器
 * 基于nebula的数据视图提供流程绘制列表查询功能
 *
 * @author keller
 * @date 2022/8/15
 */
@Component
public class ProcessDoneDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-已办事项";
  }

  @Override
  public String buildSql() {
    return "select t.*,aht.ID_ task_id,aht.NAME_ task_name from bpm_process_instance t " +
            "left join act_hi_taskinst aht on aht.PROC_INST_ID_ = t.process_instance_id " +
            "where t.process_instance_status = 'enable'" +
            "and aht.ASSIGNEE_ = :userAccount "
            ;
  }
}
