package com.biz.crm.workflow.transform;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.workflow.sdk.vo.WorkflowUserIdentity;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.transform.IdentityTransformStrategy;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 描述：默认所有用户的身份转换</br>
 * 流程管理子系统本身没有登录，而且需要支持CRM体系统（包括二开过程中）中所有的用户身份。
 * 所以无论是那种用户调用流程管理子系统的接口，都将源子系统的用户身份转成流程管理子系统特有的用户身份
 *
 * @author keller
 * @date 2022/8/19
 */
@Component
public class AllIdentityTransformStrategy implements IdentityTransformStrategy {

  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;

  @Override
  public int getOrder() {
    return 0;
  }

  @Override
  public boolean matched(String sourceIdentityType) {
    // 无论是什么用户访问workflow，都以此为转换
    return true;
  }

  @Override
  public UserIdentity transform(String sourceIdentityType, String sourceTenantCode, String sourceAccount, JSONObject userObject) {
    String[] roleCodes = this.simpleSecurityProperties.getIndependencyRoles();
    String userName = null;
    String postCode = null;
    String postName = null;
    String orgCode = null;
    String orgName = null;
    String identityType = null;
    String realName = null;
    if (ObjectUtils.isNotEmpty(userObject)) {
      userName = userObject.getString("username");
      postCode = userObject.getString("postCode");
      postName = userObject.getString("postName");
      orgCode = userObject.getString("orgCode");
      orgName = userObject.getString("orgName");
      identityType = userObject.getString("identityType");
      realName = userObject.getString("realName");
    }
    WorkflowUserIdentity workflowUserIdentity = new WorkflowUserIdentity(sourceAccount, userName, postCode, postName, orgCode, orgName, sourceTenantCode, roleCodes);
    workflowUserIdentity.setIdentityType(identityType);
    workflowUserIdentity.setRealName(realName);
    return workflowUserIdentity;
  }

}

