package com.biz.crm.workflow;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import java.net.UnknownHostException;

@MapperScan(value={"com.biz.crm.workflow.**.mapper*"})
@EnableFeignClients(basePackages = "com.biz.crm.*")
@SpringBootApplication(scanBasePackages = {"com.biz.crm.*","com.bizunited.nebula.*"})
@EnableTransactionManagement
@Slf4j
@EnableDiscoveryClient
@EnableScheduling
public class ActivitiApplication {
  public static void main(String[] args) throws UnknownHostException {
    System.setProperty("es.set.netty.runtime.available.processors", "false");
    ConfigurableApplicationContext application = SpringApplication.run(ActivitiApplication.class, args);
    Environment env = application.getEnvironment();
    String port = env.getProperty("server.port");
    String path = env.getProperty("server.servlet.context-path");
    log.info("\n----------------------------------------------------------\n\t" +
            "Application crm-activiti is running! Access URLs:\n\t" +
            "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
            "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
            "----------------------------------------------------------");
  }
}
