package com.biz.crm.workflow.expression;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 描述：</br>流程扭转实例表达式
 *
 * @author keller
 * @date 2022/11/9
 */
@Component("simpleExpression")
public class SimpleExpression {

  /**
   * 包含字符串功能
   *
   * @param target
   * @param word
   * @return
   */
  public boolean contains(String target, String word) {
    if (StringUtils.isBlank(target) || StringUtils.isBlank(word)) {
      return false;
    }
    return target.contains(word);
  }

  /**
   * 包含字符串功能
   *
   * @param targets
   * @param word
   * @return
   */
  public boolean contains(List<String> targets, String word) {
    if (CollectionUtils.isEmpty(targets) || StringUtils.isBlank(word)) {
      return false;
    }
    return targets.contains(word);
  }

  /**
   * 数组包含字符串功能
   *
   * @param targets
   * @param words
   * @return
   */
  public boolean containsAny(List<String> targets, String... words) {
    if (CollectionUtils.isEmpty(targets) || ArrayUtils.isEmpty(words)) {
      return false;
    }
    return CollectionUtils.containsAny(targets, Arrays.asList(words));
  }
}
