package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>沟通事项数据视图注册器
 * 基于nebula的数据视图提供流程绘制列表查询功能
 * @author jerry7
 */
@Component
public class ProcessCommunicateDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-沟通事项";
  }

  @Override
  public String buildSql() {
    return "select distinct t.* from bpm_process_task_communicate t " +
            "where t.tenant_code = :tenantCode " +
            "and t.target_user_name = :userAccount " +
            "or t.create_account = :userAccount " ;
  }
}
