package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>流程抄送数据视图注册器
 * 基于nebula的数据视图提供流程绘制列表查询功能
 * TODO 待确认抄送接受人账号信息后完成
 *
 * @author keller
 * @date 2022/8/15
 */
@Component
public class ProcessCopyDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-抄送事项";
  }

  @Override
  public String buildSql() {
    return " select distinct t.*" +
            "    from bpm_process_task_copy t" +
            "    left join bpm_process_instance bpi on bpi.process_instance_id = t.process_instance_id " +
            "where bpi.tenant_code = :tenantCode " +
            "and t.user_code = :userAccount "+
            "and bpi.process_instance_status = 'enable'"
            ;
  }
}
