package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author : rentao
 * @date : 2022/11/10 17:37
 */
@Component
public class ProcessDelegateToDoDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-委托待办事项";
  }

  @Override
  public String buildSql() {
    return  " select DISTINCT t.*, artv.TASK_ID_ task_id,artv.ACT_NAME_ task_name from bpm_process_instance t  " +
            " left join (select art.TASK_ID_,art.ACT_NAME_,art.PROC_INST_ID_ ,art.ACT_ID_ ,art.ASSIGNEE_ from act_ru_actinst art INNER JOIN (select MAX(START_TIME_) as START_TIME_,PROC_INST_ID_ from act_ru_actinst  where  END_TIME_ is null GROUP BY PROC_INST_ID_ ) artm on art.PROC_INST_ID_ = artm.PROC_INST_ID_ and art.START_TIME_ = artm.START_TIME_) artv on artv.PROC_INST_ID_ = t.process_instance_id" +
            " left join act_ru_identitylink ari on artv.TASK_ID_ = ari.TASK_ID_ " +
            " left join bpm_process_todo_delegate bptd on ari.USER_ID_ = bptd.user_name " +
            " left join bpm_process_todo_delegate_detail bptdd on bptdd.delegate_id = bptd.id " +
            " where t.tenant_code = :tenantCode " +
            " and  t.process_status in ('0','2')  " +
            " and bptdd.delegate_user_name = :userAccount and now() >= bptd.start_time and bptd.end_time >= now() " ;
  }
}