package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>流程绘制数据视图注册器
 * 基于nebula的数据视图提供流程绘制列表查询功能
 *
 * @author keller
 * @date 2022/8/15
 */
@Component
public class ProcessDrawingDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-流程绘制";
  }

  @Override
  public String buildSql() {
    return "select t.* from bpm_process_template t " +
            "where t.tenant_code = :tenantCode " +
            "and t.create_account = :userAccount " +
            "and t.del_flag = '009' " +
            "and t.newest = 1 "
            ;
  }
}
