package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>流程待办数据视图注册器
 * 基于nebula的数据视图提供流程绘制列表查询功能
 *
 * @author keller
 * @date 2022/8/15
 */
@Component
public class ProcessToDoDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-待办事项";
  }

  @Override
  public String buildSql() {
    return  " select DISTINCT t.*, artv.TASK_ID_ task_id,artv.ACT_NAME_ task_name from bpm_process_instance t  " +
            " left join (select art.TASK_ID_,art.ACT_NAME_,art.PROC_INST_ID_ ,art.ACT_ID_ ,art.ASSIGNEE_ from act_ru_actinst art INNER JOIN (select MAX(START_TIME_) as START_TIME_,PROC_INST_ID_ from act_ru_actinst  where  END_TIME_ is null GROUP BY PROC_INST_ID_ ) artm on art.PROC_INST_ID_ = artm.PROC_INST_ID_ and art.START_TIME_ = artm.START_TIME_) artv on artv.PROC_INST_ID_ = t.process_instance_id" +
            " left join act_ru_identitylink ari on artv.TASK_ID_ = ari.TASK_ID_ " +
            " where t.tenant_code = :tenantCode " +
            " and  t.process_status in ('0','2')  " +
            " and  ( ari.USER_ID_ = :userAccount and ari.TYPE_ = 'candidate' and t.process_instance_status = 'enable' and artv.ASSIGNEE_ is NULL ) " ;
  }
}
