package com.biz.crm.workflow.register;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>工作流列表工具使用用户筛选策略
 *
 * @author keller
 * @date 2022/9/28
 */
@Component("workflowAccountParamFieldBindingStrategy")
public class WorkflowAccountParamFieldBindingStrategy implements ParameterValueBindingStrategy {
  @Autowired
  private LoginUserService loginUserService;

  private static final String PARAM_BIND_TYPE = "Current_Type_Account";

  @Override
  public String getBindType() {
    return WorkflowAccountParamFieldBindingStrategy.PARAM_BIND_TYPE;
  }

  @Override
  public String getBindTypeCnName() {
    return "查询工作流执行者账号";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    // 各种可序列化的字符类型都可以使用
    return new Class<?>[]{CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
    UserIdentity userIdentity = loginUserService.getLoginUser();
    if (userIdentity == null) {
      return null;
    }
    // 返回当前执行者账号
    return StringUtils.join(userIdentity.getIdentityType(), ":", userIdentity.getAccount());
  }
}
