package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>流程管理数据视图注册器
 * 基于nebula的数据视图提供流程绘制列表查询功能
 *
 * @author keller
 * @date 2022/8/15
 */
@Component
public class ProcessManageDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-流程管理";
  }

  @Override
  public String buildSql() {
    return "select distinct t.*,art.ID_ task_id,art.NAME_ task_name from bpm_process_instance t " +
            "left join act_ru_task art on art.PROC_INST_ID_ = t.process_instance_id " +
            "where t.tenant_code = :tenantCode "
            ;
  }
}
