package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author : rentao
 * @date : 2022/11/10 17:40
 */
@Component
public class ProcessOptionalToDoDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-自选待办事项";
  }

  @Override
  public String buildSql() {
    return  " select DISTINCT t.*, artv.TASK_ID_ task_id,artv.ACT_NAME_ task_name from bpm_process_instance t  " +
            " inner join act_ru_actinst artv on artv.PROC_INST_ID_ = t.process_instance_id" +
            " left join bpm_process_instance_assignee bpia on bpia.process_instance_id = t.process_instance_id  and artv.ACT_ID_ = bpia.process_task_id " +
            " where t.tenant_code = :tenantCode " +
            " and exists (SELECT MAX( START_TIME_ ) AS START_TIME_, PROC_INST_ID_ FROM act_ru_actinst ara where ara.PROC_INST_ID_ = t.process_instance_id and END_TIME_ IS null and ASSIGNEE_ IS NULL GROUP BY PROC_INST_ID_ ) " +
            " and bpia.assignee_name = :userAccount  "
            ;
  }
}