package com.biz.crm.workflow.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>流程被驳回数据视图注册器
 * 基于nebula的数据视图提供流程被驳回列表查询功能
 *
 * @author jerry7
 * @date 2022/11/16
 */
@Component
public class ProcessOverruledDataViewRegister implements DataviewRegister {
  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "BPM-流程中心-被驳回事项";
  }

  @Override
  public String buildSql() {
    return "select distinct t.* from bpm_process_instance t " +
            "where t.tenant_code = :tenantCode " +
            "and t.create_account = :userAccount " +
            "and t.process_instance_status = 'enable' " +
            "and t.process_status = '4' "
            ;
  }
}
