package com.biz.crm.workflow.client.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * 实体：业务流程关联表;
 *
 * @author : Keller
 * @date : 2022-8-24
 */
@ApiModel(value = "ProcessBusinessMapping", description = "业务流程关联表")
@TableName("bpm_process_business_mapping")
@Getter
@Setter
@Entity(name = "bpm_process_business_mapping")
@org.hibernate.annotations.Table(appliesTo = "bpm_process_business_mapping", comment = "业务流程关联表")
@Table(name = "bpm_process_business_mapping")
public class ProcessBusinessMapping extends TenantOpEntity {

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", notes = "创建时间", value = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "DATETIME COMMENT '创建时间 '")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 备注
   */
  @ApiModelProperty(name = "remark", notes = "备注", value = "备注")
  @Column(name = "remark", nullable = true, length = 400, columnDefinition = "VARCHAR(400) COMMENT '备注 '")
  private String remark;

  /**
   * 业务编号
   */
  @ApiModelProperty(name = "businessNo", notes = "业务编号", value = "业务编号")
  @Column(name = "business_no", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '业务编号 '")
  private String businessNo;

  /**
   * 流程编号
   */
  @ApiModelProperty(name = "processNo", notes = "流程编号", value = "流程编号")
  @Column(name = "process_no", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '流程编号 '")
  private String processNo;

  /**
   * 流程key
   */
  @ApiModelProperty(name = "processKey", notes = "流程key", value = "流程key")
  @Column(name = "process_key", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '流程key '")
  private String processKey;

  /**
   * 流程状态
   */
  @ApiModelProperty(name = "processStatus", notes = "流程状态", value = "流程状态")
  @Column(name = "process_status", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '流程状态 '")
  private String processStatus;

  /**
   * 应用名称
   */
  @ApiModelProperty(name = "applicationName", notes = "应用名称", value = "应用名称")
  @Column(name = "application_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '应用名称 '")
  private String applicationName;

  /**
   * 模块编号
   */
  @ApiModelProperty(name = "businessCode", notes = "模块编号", value = "模块编号")
  @Column(name = "business_code", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '模块编号 '")
  private String businessCode;

  /**
   * 逻辑删除
   */
  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Column(name = "del_flag", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '数据状态（删除状态）'")
  private String delFlag;

  /** 是否可编辑 */
  @ApiModelProperty(name = "canEdit",notes = "是否可编辑", value= "是否可编辑")
  @Column(name = "can_edit", nullable = true, length = 1,  columnDefinition = "bit(1) COMMENT '是否可编辑 '")
  private Boolean canEdit;

  /** 流程节点编号 */
  @ApiModelProperty(name = "taskId",notes = "流程节点编号", value= "流程节点编号")
  @Column(name = "task_id", nullable = true, length = 255,  columnDefinition = "VARCHAR(255) COMMENT '流程节点编号 '")
  private String taskId;

  /** 流程节点名称 */
  @ApiModelProperty(name = "taskName",notes = "流程节点名称", value= "流程节点名称")
  @Column(name = "task_name", nullable = true, length = 255,  columnDefinition = "VARCHAR(255) COMMENT '流程节点名称 '")
  private String taskName;

}

