package com.biz.crm.workflow.client.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.client.entity.ProcessBusinessMapping;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 业务流程关联表;(bpm_process_business_mapping)表数据库访问层
 * @author : Keller
 * @date : 2022-8-24
 */
@Mapper
public interface ProcessBusinessMappingMapper extends BaseMapper<ProcessBusinessMapping> {
  /**
   * 分页查询所有数据
   *
   * @param page 分页参数
   * @param dto 动态查询条件
   * @return 分页对象列表
   */
  Page<ProcessBusinessMappingVo> findByConditions(@Param("page") Page<ProcessBusinessMappingVo> page , @Param("dto") ProcessBusinessMappingDto dto);

  /**
   * 根据条件查询单条数据
   * @param dto
   * @return
   */
  ProcessBusinessMappingVo findSignalByConditions(@Param("dto") ProcessBusinessMappingDto dto);

  /**
   * 根据条件查询多条数据
   *
   * @param dto
   * @return
   */
  List<ProcessBusinessMappingVo> findMultiByByConditions(@Param("dto") ProcessBusinessMappingDto dto);

  List<ProcessBusinessMappingVo> findAllRelationalByProcessNo(@Param("processNo") String processNo);
}
