/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.client.observer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.workflow.client.listener.ProcessStatusListener;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
class ProcessStatusEventListener
implements ProcessStatusListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessStatusEventListener.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ProcessCompleteListener> processCompleteListeners;

    ProcessStatusEventListener() {
    }

    @Override
    @Transactional
    public void onProcessStatusChanged(ProcessStatusDto dto) {
        log.info("\u6d88\u606f\u901a\u77e5\u53c2\u6570\uff1a\uff1a{}::{}", (Object)JSON.toJSONString((Object)dto), (Object)this.applicationName);
        log.warn("\u6d88\u606f\u901a\u77e5\u53c2\u6570\uff1a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (dto == null || !dto.getApplicationName().equals(this.applicationName)) {
            return;
        }
        log.info("\u6d88\u606f\u901a\u77e5\u53c2\u6570processCompleteListeners\uff1a\uff1a{}", (Object)JSON.toJSONString(this.processCompleteListeners));
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(dto.getProcessNo());
        processBusinessMappingDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            processBusinessMappingDto.setProcessStatus(ProcessStatusEnum.START.getDictCode());
            processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
            if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
                log.warn("\u4e1a\u52a1\u7f16\u7801{}\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f\u72b6\u6001\u65e0\u6548\uff0c\u53ef\u80fd\u662f\u591a\u6b21\u56de\u8c03", (Object)dto.getBusinessNo());
                return;
            }
        }
        log.info("\u6d88\u606f\u901a\u77e5\u53c2\u6570processBusinessMappingVoList\uff1a\uff1a{}", (Object)JSON.toJSONString((Object)processBusinessMappingVoList));
        try {
            List ids = processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getId).collect(Collectors.toList());
            this.processBusinessMappingService.updateProcessStatusById(ids, dto.getProcessStatus());
            if (!CollectionUtils.isEmpty(this.processCompleteListeners)) {
                List businessCodeList = processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
                dto.setBusinessNoList(businessCodeList);
                this.processCompleteListeners.stream().filter(item -> item.getBusinessCode().equals(dto.getBusinessCode())).forEach(item -> item.onProcessComplete(dto));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void onProcessInfoChanged(ProcessStatusDto dto) {
        if (dto == null || !dto.getApplicationName().equals(this.applicationName)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dto.getProcessNo())) {
            log.warn("\u6d41\u7a0b\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u66f4\u65b0\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(dto.getProcessNo());
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (!CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            boolean canEdit = BooleanUtils.isTrue((Boolean)dto.getCanEdit());
            List ids = processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getId).collect(Collectors.toList());
            this.processBusinessMappingService.updateCanEditByIds(ids, Boolean.valueOf(canEdit), dto.getTaskId(), dto.getTaskName());
        }
    }
}

