/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.client.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.client.entity.ProcessBusinessMapping;
import com.biz.crm.workflow.client.mapper.ProcessBusinessMappingMapper;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ProcessBusinessMappingRepository
extends ServiceImpl<ProcessBusinessMappingMapper, ProcessBusinessMapping> {
    @Autowired
    private ProcessBusinessMappingMapper processBusinessMappingMapper;

    public Page<ProcessBusinessMappingVo> findByConditions(Pageable pageable, ProcessBusinessMappingDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processBusinessMappingMapper.findByConditions((Page<ProcessBusinessMappingVo>)page, dto);
    }

    public ProcessBusinessMappingVo findSignalByConditions(ProcessBusinessMappingDto dto) {
        if (dto == null) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.processBusinessMappingMapper.findSignalByConditions(dto);
    }

    public List<ProcessBusinessMappingVo> findMultiByByConditions(ProcessBusinessMappingDto dto) {
        if (dto == null) {
            return Collections.emptyList();
        }
        dto.setTenantCode(null);
        return this.processBusinessMappingMapper.findMultiByByConditions(dto);
    }

    public List<ProcessBusinessMapping> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ProcessBusinessMapping> findByBusinessNo(String businessNo) {
        if (!StringUtils.hasText((String)businessNo)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessBusinessMapping::getBusinessNo, (Object)businessNo)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public ProcessBusinessMapping findByBusinessNoAndProcessStatus(String businessNo, String processStatus) {
        if (!StringUtils.hasText((String)businessNo)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessBusinessMapping)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessBusinessMapping::getBusinessNo, (Object)businessNo)).eq(ProcessBusinessMapping::getProcessStatus, (Object)processStatus)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public ProcessBusinessMapping findByBusinessNoAndProcessStatus(String businessNo, String processKey, String processStatus) {
        if (!StringUtils.hasText((String)businessNo)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessBusinessMapping)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessBusinessMapping::getBusinessNo, (Object)businessNo)).eq(ProcessBusinessMapping::getProcessKey, (Object)processKey)).eq(ProcessBusinessMapping::getProcessStatus, (Object)processStatus)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<ProcessBusinessMapping> findByBusinessNoAndProcessStatus(List<String> businessNoList, String processKey, String processStatus) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessBusinessMapping::getBusinessNo, businessNoList)).eq(ProcessBusinessMapping::getProcessKey, (Object)processKey)).eq(ProcessBusinessMapping::getProcessStatus, (Object)processStatus)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public ProcessBusinessMapping findByBusinessNoAndBusinessCodeAndProcessStatus(String businessNo, String businessCode, String processKey, String processStatus) {
        if (!StringUtils.hasText((String)businessNo)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessBusinessMapping)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessBusinessMapping::getBusinessNo, (Object)businessNo)).eq(ProcessBusinessMapping::getBusinessCode, (Object)businessCode)).eq(ProcessBusinessMapping::getProcessKey, (Object)processKey)).eq(ProcessBusinessMapping::getProcessStatus, (Object)processStatus)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<ProcessBusinessMapping> findByBusinessNoAndBusinessCodeAndProcessStatus(List<String> businessNoList, String businessCode, String processKey, String processStatus) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessBusinessMapping::getBusinessNo, businessNoList)).eq(ProcessBusinessMapping::getBusinessCode, (Object)businessCode)).eq(ProcessBusinessMapping::getProcessKey, (Object)processKey)).eq(ProcessBusinessMapping::getProcessStatus, (Object)processStatus)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByBusinessNoAndBusinessCodeAndProcessKey(String businessNo, String businessCode, String processKey) {
        if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{businessNo, businessCode, processKey})) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessBusinessMapping::getBusinessNo, (Object)businessNo)).eq(ProcessBusinessMapping::getBusinessCode, (Object)businessCode)).eq(ProcessBusinessMapping::getProcessKey, (Object)processKey)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).set(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public ProcessBusinessMapping findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessBusinessMapping)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void updateByIdAndTenantCode(ProcessBusinessMapping processBusinessMapping, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{processBusinessMapping.getId()});
        ((ProcessBusinessMappingMapper)this.baseMapper).update((Object)processBusinessMapping, (Wrapper)lambdaUpdateWrapper);
    }

    public void deleteByBusinessNoAndBusinessCodeAndProcessKey(List<String> businessNoList, String businessCode, String processKey) {
        if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{businessCode, processKey})) {
            return;
        }
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ProcessBusinessMapping::getBusinessNo, businessNoList)).eq(ProcessBusinessMapping::getBusinessCode, (Object)businessCode)).eq(ProcessBusinessMapping::getProcessKey, (Object)processKey)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).set(ProcessBusinessMapping::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateProcessStatusByIds(List<String> ids, String processStatus) {
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(ProcessBusinessMapping::getProcessStatus, (Object)processStatus)).update();
    }

    public void updateCanEditByIds(List<String> ids, Boolean canEdit, String taskId, String taskName) {
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).set(ProcessBusinessMapping::getCanEdit, (Object)canEdit)).set(ProcessBusinessMapping::getTaskId, (Object)taskId)).set(ProcessBusinessMapping::getTaskName, (Object)taskName)).update();
    }

    public List<ProcessBusinessMappingVo> findAllRelationalByProcessNo(String processNo) {
        return this.processBusinessMappingMapper.findAllRelationalByProcessNo(processNo);
    }
}

