/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.client.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.client.entity.ProcessBusinessMapping;
import com.biz.crm.workflow.client.repository.ProcessBusinessMappingRepository;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processBusinessMappingService")
public class ProcessBusinessMappingServiceImpl
implements ProcessBusinessMappingService {
    private static final Logger log = LoggerFactory.getLogger(ProcessBusinessMappingServiceImpl.class);
    @Autowired
    private ProcessBusinessMappingRepository processBusinessMappingRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Page<ProcessBusinessMappingVo> findByConditions(Pageable pageable, ProcessBusinessMappingDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessBusinessMappingDto();
        }
        return this.processBusinessMappingRepository.findByConditions(pageable, dto);
    }

    public ProcessBusinessMappingVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessBusinessMapping processBusinessMapping = this.processBusinessMappingRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processBusinessMapping == null) {
            return null;
        }
        ProcessBusinessMappingVo processBusinessMappingVo = (ProcessBusinessMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processBusinessMapping, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processBusinessMappingVo;
    }

    public List<ProcessBusinessMappingVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessBusinessMapping> processBusinessMappings = this.processBusinessMappingRepository.findByIds(ids);
        Collection processBusinessMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(processBusinessMappings, ProcessBusinessMapping.class, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processBusinessMappingVos);
    }

    @Transactional
    public ProcessBusinessMappingVo create(ProcessBusinessMappingDto processBusinessMappingDto) {
        this.createValidate(processBusinessMappingDto);
        ProcessBusinessMapping processBusinessMapping = (ProcessBusinessMapping)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processBusinessMappingDto, ProcessBusinessMapping.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processBusinessMapping.setTenantCode(TenantUtils.getTenantCode());
        processBusinessMapping.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.processBusinessMappingRepository.saveOrUpdate((Object)processBusinessMapping);
        ProcessBusinessMappingVo processBusinessMappingVo = (ProcessBusinessMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processBusinessMapping, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processBusinessMappingVo.setId(processBusinessMapping.getId());
        return processBusinessMappingVo;
    }

    @Transactional
    public List<ProcessBusinessMappingVo> create(List<ProcessBusinessMappingDto> processBusinessMappingDtoList) {
        for (ProcessBusinessMappingDto processBusinessMappingDto : processBusinessMappingDtoList) {
            this.createValidate(processBusinessMappingDto);
        }
        List processBusinessMappingList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processBusinessMappingDtoList, ProcessBusinessMappingDto.class, ProcessBusinessMapping.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        for (ProcessBusinessMapping processBusinessMapping : processBusinessMappingList) {
            processBusinessMapping.setTenantCode(TenantUtils.getTenantCode());
            processBusinessMapping.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        this.processBusinessMappingRepository.saveBatch(processBusinessMappingList);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processBusinessMappingList, ProcessBusinessMapping.class, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public ProcessBusinessMappingVo findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(String processBusinessNo, String processBusinessCode, String processKey, String processStatus) {
        ProcessBusinessMapping processBusinessMapping = null;
        processBusinessMapping = StringUtils.isBlank((CharSequence)processBusinessCode) ? this.processBusinessMappingRepository.findByBusinessNoAndProcessStatus(processBusinessNo, processKey, processStatus) : this.processBusinessMappingRepository.findByBusinessNoAndBusinessCodeAndProcessStatus(processBusinessNo, processBusinessCode, processKey, processStatus);
        if (processBusinessMapping == null) {
            return null;
        }
        ProcessBusinessMappingVo processBusinessMappingVo = (ProcessBusinessMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processBusinessMapping, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processBusinessMappingVo;
    }

    public List<ProcessBusinessMappingVo> findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(List<String> processBusinessNoList, String processBusinessCode, String processKey, String processStatus) {
        List<Object> processBusinessMappingList = Lists.newArrayList();
        processBusinessMappingList = StringUtils.isBlank((CharSequence)processBusinessCode) ? this.processBusinessMappingRepository.findByBusinessNoAndProcessStatus(processBusinessNoList, processKey, processStatus) : this.processBusinessMappingRepository.findByBusinessNoAndBusinessCodeAndProcessStatus(processBusinessNoList, processBusinessCode, processKey, processStatus);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingList)) {
            return Lists.newArrayList();
        }
        List processBusinessMappingVo = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processBusinessMappingList, ProcessBusinessMapping.class, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processBusinessMappingVo;
    }

    @Transactional
    public void updateProcessStatusById(String id, String processStatus) {
        ProcessBusinessMapping processBusinessMapping = this.processBusinessMappingRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        processBusinessMapping.setProcessStatus(processStatus);
        this.processBusinessMappingRepository.updateByIdAndTenantCode(processBusinessMapping, TenantUtils.getTenantCode());
    }

    @Transactional
    public void updateProcessStatusById(List<String> ids, String processStatus) {
        this.processBusinessMappingRepository.updateProcessStatusByIds(ids, processStatus);
    }

    @Transactional
    public void updateCanEditById(String id, Boolean canEdit, String taskId, String taskName) {
        ProcessBusinessMapping processBusinessMapping = this.processBusinessMappingRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        processBusinessMapping.setCanEdit(canEdit);
        processBusinessMapping.setTaskId(taskId);
        processBusinessMapping.setTaskName(taskName);
        this.processBusinessMappingRepository.updateByIdAndTenantCode(processBusinessMapping, TenantUtils.getTenantCode());
    }

    @Transactional
    public void updateCanEditByIds(List<String> ids, Boolean canEdit, String taskId, String taskName) {
        this.processBusinessMappingRepository.updateCanEditByIds(ids, canEdit, taskId, taskName);
    }

    public ProcessBusinessMappingVo findSignalByConditions(ProcessBusinessMappingDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            return null;
        }
        return this.processBusinessMappingRepository.findSignalByConditions(dto);
    }

    public List<ProcessBusinessMappingVo> findMultiByByConditions(ProcessBusinessMappingDto dto) {
        log.info("\u6d88\u606f\u901a\u77e5\u53c2\u6570findMultiByByConditions{}", (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtils.isEmpty((Object)dto)) {
            return Collections.emptyList();
        }
        return this.processBusinessMappingRepository.findMultiByByConditions(dto);
    }

    public List<ProcessBusinessMappingVo> findAllRelationalByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Collections.emptyList();
        }
        return this.processBusinessMappingRepository.findAllRelationalByProcessNo(processNo);
    }

    @Transactional
    public void deleteByBusinessNoAndBusinessCodeAndProcessKey(String processBusinessNo, String processBusinessCode, String processKey) {
        this.processBusinessMappingRepository.deleteByBusinessNoAndBusinessCodeAndProcessKey(processBusinessNo, processBusinessCode, processKey);
    }

    @Transactional
    public void deleteByBusinessNoAndBusinessCodeAndProcessKey(List<String> processBusinessNoList, String processBusinessCode, String processKey) {
        this.processBusinessMappingRepository.deleteByBusinessNoAndBusinessCodeAndProcessKey(processBusinessNoList, processBusinessCode, processKey);
    }

    private void createValidate(ProcessBusinessMappingDto processBusinessMappingDto) {
        Validate.notNull((Object)processBusinessMappingDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processBusinessMappingDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processBusinessMappingDto.getBusinessNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processBusinessMappingDto.getProcessNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processBusinessMappingDto.getProcessKey(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processBusinessMappingDto.getProcessStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

