package com.biz.crm.workflow.client.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.client.entity.ProcessBusinessMapping;
import com.biz.crm.workflow.client.repository.ProcessBusinessMappingRepository;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

/**
 * 业务流程关联表;(bpm_process_business_mapping)表服务实现类
 *
 * @author : Keller
 * @date : 2022-8-24
 */
@Service("processBusinessMappingService")
public class ProcessBusinessMappingServiceImpl implements ProcessBusinessMappingService {
  @Autowired
  private ProcessBusinessMappingRepository processBusinessMappingRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;


  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  @Override
  public Page<ProcessBusinessMappingVo> findByConditions(Pageable pageable, ProcessBusinessMappingDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new ProcessBusinessMappingDto();
    }
    return this.processBusinessMappingRepository.findByConditions(pageable, dto);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public ProcessBusinessMappingVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ProcessBusinessMapping processBusinessMapping = this.processBusinessMappingRepository.getById(id);
    if (processBusinessMapping == null) {
      return null;
    }
    ProcessBusinessMappingVo processBusinessMappingVo = this.nebulaToolkitService.copyObjectByWhiteList(processBusinessMapping, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class);
    return processBusinessMappingVo;
  }

  /**
   * 通过主键查询多条数据
   *
   * @param ids 主键集合
   * @return 多条数据
   */
  @Override
  public List<ProcessBusinessMappingVo> findByIds(Collection<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newArrayList();
    }
    List<ProcessBusinessMapping> processBusinessMappings = this.processBusinessMappingRepository.findByIds(ids);
    Collection<ProcessBusinessMappingVo> processBusinessMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(processBusinessMappings, ProcessBusinessMapping.class, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class);
    return Lists.newArrayList(processBusinessMappingVos);
  }

  /**
   * 新增数据
   *
   * @param processBusinessMappingDto 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public ProcessBusinessMappingVo create(ProcessBusinessMappingDto processBusinessMappingDto) {

    this.createValidate(processBusinessMappingDto);
    ProcessBusinessMapping processBusinessMapping = this.nebulaToolkitService.copyObjectByWhiteList(processBusinessMappingDto, ProcessBusinessMapping.class, LinkedHashSet.class, ArrayList.class);
    processBusinessMapping.setTenantCode(TenantUtils.getTenantCode());
    processBusinessMapping.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    this.processBusinessMappingRepository.saveOrUpdate(processBusinessMapping);
    ProcessBusinessMappingVo processBusinessMappingVo = this.nebulaToolkitService.copyObjectByWhiteList(processBusinessMapping, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class);

    processBusinessMappingVo.setId(processBusinessMapping.getId());

    return processBusinessMappingVo;
  }

  @Override
  public ProcessBusinessMappingVo findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(String processBusinessNo, String processBusinessCode, String processKey, String processStatus) {
    ProcessBusinessMapping processBusinessMapping = null;
    if (StringUtils.isBlank(processBusinessCode)) {
      processBusinessMapping = this.processBusinessMappingRepository.findByBusinessNoAndProcessStatus(processBusinessNo, processKey, processStatus);
    } else {
      processBusinessMapping = this.processBusinessMappingRepository.findByBusinessNoAndBusinessCodeAndProcessStatus(processBusinessNo, processBusinessCode, processKey, processStatus);
    }
    if (processBusinessMapping == null) {
      return null;
    }
    ProcessBusinessMappingVo processBusinessMappingVo = this.nebulaToolkitService.copyObjectByWhiteList(processBusinessMapping, ProcessBusinessMappingVo.class, LinkedHashSet.class, ArrayList.class);
    return processBusinessMappingVo;
  }

  @Override
  @Transactional
  public void updateProcessStatusById(String id, String processStatus) {
    ProcessBusinessMapping processBusinessMapping = this.processBusinessMappingRepository.getById(id);
    processBusinessMapping.setProcessStatus(processStatus);
    this.processBusinessMappingRepository.updateById(processBusinessMapping);
  }

  @Override
  @Transactional
  public void updateCanEditById(String id, Boolean canEdit, String taskId, String taskName) {
    ProcessBusinessMapping processBusinessMapping = this.processBusinessMappingRepository.getById(id);
    processBusinessMapping.setCanEdit(canEdit);
    processBusinessMapping.setTaskId(taskId);
    processBusinessMapping.setTaskName(taskName);
    this.processBusinessMappingRepository.updateById(processBusinessMapping);
  }

  @Override
  public ProcessBusinessMappingVo findSignalByConditions(ProcessBusinessMappingDto dto) {
    if (ObjectUtils.isEmpty(dto)) {
      return null;
    }
    return this.processBusinessMappingRepository.findSignalByConditions(dto);
  }

  @Override
  public List<ProcessBusinessMappingVo> findMultiByByConditions(ProcessBusinessMappingDto dto) {
    if (ObjectUtils.isEmpty(dto)) {
      return Collections.emptyList();
    }
    return this.processBusinessMappingRepository.findMultiByByConditions(dto);
  }

  @Override
  @Transactional
  public void deleteByBusinessNoAndBusinessCodeAndProcessKey(String processBusinessNo, String processBusinessCode, String processKey) {
    this.processBusinessMappingRepository.deleteByBusinessNoAndBusinessCodeAndProcessKey(processBusinessNo, processBusinessCode, processKey);
  }

  /**
   * 创建验证
   *
   * @param processBusinessMappingDto
   */
  private void createValidate(ProcessBusinessMappingDto processBusinessMappingDto) {
    Validate.notNull(processBusinessMappingDto, "新增时，对象信息不能为空！");
    Validate.isTrue(processBusinessMappingDto.getId() == null, "新增数据时,数据主键不为空!");
    Validate.notBlank(processBusinessMappingDto.getBusinessNo(), "新增数据时，业务编号不能为空！");
    Validate.notBlank(processBusinessMappingDto.getProcessNo(), "新增数据时，流程编号不能为空！");
    Validate.notBlank(processBusinessMappingDto.getProcessKey(), "新增数据时，流程key不能为空！");
    Validate.notBlank(processBusinessMappingDto.getProcessStatus(), "新增数据时，流程状态不能为空！");
  }
}
