/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.client.service.internal;

import com.biz.crm.workflow.client.listener.ProcessInfoListener;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.biz.crm.workflow.sdk.register.ProcessBusinessRegister;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.biz.crm.workflow.sdk.vo.ProcessInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessBusinessServiceImpl
implements ProcessBusinessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessBusinessServiceImpl.class);
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ProcessBusinessRegister> processBusinessRegisters;
    @Autowired(required=false)
    private List<ProcessCompleteListener> processCompleteListeners;
    @Autowired
    private ProcessBusinessService processBusinessService;

    public ProcessBusinessVo processStart(ProcessBusinessDto dto) {
        this.validateProcessStart(dto);
        Collection processBusinessCodes = null;
        processBusinessCodes = CollectionUtils.isEmpty(this.processBusinessRegisters) ? Sets.newHashSet() : (Collection)this.processBusinessRegisters.stream().map(ProcessBusinessRegister::getBusinessCode).collect(Collectors.toSet());
        ProcessBusinessVo processBusinessVo = null;
        try {
            if (processBusinessCodes.contains(dto.getBusinessCode())) {
                processBusinessVo = this.processBusinessService.create(dto);
                dto.setProcessNo(processBusinessVo.getProcessNo());
                String processStatus = this.processBusinessService.startProcess(dto);
                processBusinessVo.setProcessStatus(processStatus);
            } else {
                dto.setSkipped(true);
                this.skip(dto);
                processBusinessVo = new ProcessBusinessVo();
                processBusinessVo.setSkipped(true);
                processBusinessVo.setBusinessNo(dto.getBusinessNo());
                processBusinessVo.setBusinessCode(dto.getBusinessCode());
                processBusinessVo.setApplicationName(dto.getApplicationName());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(String.format("\u53d1\u8d77\u6d41\u7a0b\u9519\u8bef:%s", e.getMessage()), e);
        }
        return processBusinessVo;
    }

    @Transactional
    public ProcessBusinessVo create(ProcessBusinessDto dto) {
        dto.setApplicationName(this.applicationName);
        dto.setTenantCode(TenantUtils.getTenantCode());
        ProcessStatusDto processStatusDto = new ProcessStatusDto();
        ProcessBusinessMappingVo processBusinessMaVo = this.processBusinessMappingService.findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(dto.getBusinessNo(), dto.getBusinessCode(), dto.getProcessKey(), ProcessStatusEnum.START.getDictCode());
        if (Objects.nonNull(processBusinessMaVo)) {
            processStatusDto.setProcessTitle(dto.getProcessTitle());
            processStatusDto.setBusinessNo(dto.getBusinessNo());
            processStatusDto.setProcessKey(dto.getProcessKey());
            processStatusDto.setProcessNo(processBusinessMaVo.getProcessNo());
            processStatusDto.setProcessStatus(ProcessStatusEnum.START.getDictCode());
            processStatusDto.setApplicationName(this.applicationName);
            processStatusDto.setBusinessCode(dto.getBusinessCode());
            processStatusDto.setRemark(dto.getRemark());
            ProcessBusinessVo processBusinessVo = (ProcessBusinessVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processStatusDto, ProcessBusinessVo.class, HashSet.class, ArrayList.class, new String[0]);
            return processBusinessVo;
        }
        ProcessBusinessMappingVo processBusinessMappingVo = this.processBusinessMappingService.findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(dto.getBusinessNo(), dto.getBusinessCode(), dto.getProcessKey(), ProcessStatusEnum.COMMIT.getDictCode());
        Validate.isTrue((processBusinessMappingVo == null ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7[%s]\u5df2\u7ecf\u5b58\u5728\u5f85\u5ba1\u6279\u6d41\u7a0b,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{dto.getBusinessNo()});
        processBusinessMappingVo = this.processBusinessMappingService.findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(dto.getBusinessNo(), dto.getBusinessCode(), dto.getProcessKey(), ProcessStatusEnum.PASS.getDictCode());
        Validate.isTrue((processBusinessMappingVo == null ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7[%s]\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u901a\u8fc7\u8bb0\u5f55,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{dto.getBusinessNo()});
        ProcessInfoResponse response = null;
        SerializableBiConsumer & Serializable sf = ProcessInfoListener::createProcess;
        response = (ProcessInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, ProcessInfoListener.class, (SerializableBiConsumer)sf);
        Validate.notNull((Object)response, (String)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe\u662f\u5426\u6b63\u5e38", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)response.getProcessNo(), (String)"\u6d41\u7a0b[%s]\u521b\u5efa\u5931\u8d25", (Object[])new Object[]{response.getProcessKey()});
        log.debug("\u521b\u5efa\u6d41\u7a0b-\u4e1a\u52a1\u7f16\u53f7\uff1a{},\u6d41\u7a0b\u7f16\u53f7:{}", (Object)response.getBusinessNo(), (Object)response.getProcessNo());
        dto.setProcessNo(response.getProcessNo());
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setBusinessNo(response.getBusinessNo());
        processBusinessMappingDto.setProcessKey(response.getProcessKey());
        processBusinessMappingDto.setProcessNo(response.getProcessNo());
        processBusinessMappingDto.setApplicationName(this.applicationName);
        processBusinessMappingDto.setBusinessCode(dto.getBusinessCode());
        processBusinessMappingDto.setProcessStatus(ProcessStatusEnum.START.getDictCode());
        this.processBusinessMappingService.deleteByBusinessNoAndBusinessCodeAndProcessKey(dto.getBusinessNo(), dto.getBusinessCode(), dto.getProcessKey());
        processBusinessMappingVo = this.processBusinessMappingService.create(processBusinessMappingDto);
        processStatusDto.setProcessTitle(dto.getProcessTitle());
        processStatusDto.setBusinessNo(dto.getBusinessNo());
        processStatusDto.setProcessKey(dto.getProcessKey());
        processStatusDto.setProcessNo(response.getProcessNo());
        processStatusDto.setProcessStatus(ProcessStatusEnum.START.getDictCode());
        processStatusDto.setApplicationName(this.applicationName);
        processStatusDto.setBusinessCode(dto.getBusinessCode());
        processStatusDto.setRemark(dto.getRemark());
        ProcessBusinessVo processBusinessVo = (ProcessBusinessVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processStatusDto, ProcessBusinessVo.class, HashSet.class, ArrayList.class, new String[0]);
        return processBusinessVo;
    }

    @Transactional
    public void start(ProcessBusinessDto dto) {
        this.initiateProcess(dto);
    }

    @Transactional
    public String startProcess(ProcessBusinessDto dto) {
        return this.initiateProcess(dto);
    }

    private void skip(ProcessBusinessDto dto) {
        if (!CollectionUtils.isEmpty(this.processCompleteListeners)) {
            this.processCompleteListeners.stream().filter(item -> item.getBusinessCode().equals(dto.getBusinessCode())).forEach(item -> {
                ProcessStatusDto processStatusDto = new ProcessStatusDto();
                processStatusDto.setBusinessCode(dto.getBusinessCode());
                processStatusDto.setBusinessNo(dto.getBusinessNo());
                processStatusDto.setApplicationName(dto.getApplicationName());
                processStatusDto.setTenantCode(TenantUtils.getTenantCode());
                processStatusDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
                log.debug("\u8df3\u8fc7\u6d41\u7a0b-\u4e1a\u52a1\u7f16\u53f7\uff1a{},\u6d41\u7a0b\u7f16\u53f7:{}", (Object)dto.getBusinessNo(), (Object)dto.getProcessNo());
                item.onProcessComplete(processStatusDto);
            });
        }
    }

    private void validateProcessStart(ProcessBusinessDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u8d77\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessNo(), (String)"\u53d1\u8d77\u6d41\u7a0b\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessTitle(), (String)"\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private String initiateProcess(ProcessBusinessDto dto) {
        Validate.notNull((Object)dto, (String)"\u542f\u52a8\u6d41\u7a0b\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessNo(), (String)"\u542f\u52a8\u6d41\u7a0b\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ProcessInfoResponse response = null;
        SerializableBiConsumer & Serializable sf = ProcessInfoListener::startProcess;
        response = (ProcessInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, ProcessInfoListener.class, (SerializableBiConsumer)sf);
        Validate.notNull((Object)response, (String)"\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5de5\u4f5c\u6d41\u670d\u52a1\u662f\u5426\u6b63\u5e38\u542f\u52a8", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)response.getProcessNo(), (String)"\u6d41\u7a0b[%s]\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25", (Object[])new Object[]{response.getProcessKey()});
        log.debug("\u53d1\u8d77\u6d41\u7a0b-\u4e1a\u52a1\u7f16\u53f7\uff1a{},\u6d41\u7a0b\u7f16\u53f7:{}", (Object)response.getBusinessNo(), (Object)response.getProcessNo());
        ProcessBusinessMappingVo processBusinessMappingVo = this.processBusinessMappingService.findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(response.getBusinessNo(), dto.getBusinessCode(), dto.getProcessKey(), ProcessStatusEnum.START.getDictCode());
        if (processBusinessMappingVo != null) {
            this.processBusinessMappingService.updateProcessStatusById(processBusinessMappingVo.getId(), response.getProcessStatus());
        }
        return response.getProcessStatus();
    }
}

