package com.biz.crm.workflow.client.listener;

import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 描述：</br>流程状态变动监听
 *
 * @author keller
 * @date 2022/8/25
 */
public interface ProcessStatusListener extends NebulaEvent {

  /**
   * 当流程开始后触发该事件
   */
  void onProcessStatusChanged(ProcessStatusDto dto);

  /**
   * 流程信息发生改变（从一个手工任务流转至另一个手工任务时候）
   * @param dto
   */
  void onProcessInfoChanged(ProcessStatusDto dto);
}
