package com.biz.crm.workflow.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.feign.feign.internal.TodoOverruledVoServiceFeignImpl;
import com.biz.crm.workflow.sdk.vo.TodoOverruledVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @title TodoOverruledVoServiceFeign
 * @date 2023/5/9 15:39
 * @author Kevin
 * @description 待办和被驳回计数feign接口
 */
@FeignClient(
    name = "${workflow.feign-client.name:crm-workflow}",
    path = "crm-workflow",
    fallbackFactory = TodoOverruledVoServiceFeignImpl.class)
public interface TodoOverruledVoServiceFeign {

  @ApiOperation(value = "查询当前用户的待办和被驳回的流程数量汇总")
  @GetMapping(value = "/v1/todoOverruled/todoOverruled/todoOverruledCount")
  Result<TodoOverruledVo> todoOverruledCount();


}
