package com.biz.crm.workflow.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.feign.feign.TodoOverruledVoServiceFeign;
import com.biz.crm.workflow.sdk.vo.TodoOverruledVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

/**
 * @title TodoOverruledVoServiceFeignImpl
 * @date 2023/5/9 15:41
 * @author Kevin
 * @description 待办和被驳回计数feign熔断实现
 */
@Component
public class TodoOverruledVoServiceFeignImpl  implements FallbackFactory<TodoOverruledVoServiceFeign> {


  @Override
  public TodoOverruledVoServiceFeign create(Throwable cause) {
    return new TodoOverruledVoServiceFeign(){
      @Override
      public Result<TodoOverruledVo> todoOverruledCount() {
        throw new UnsupportedOperationException("查询当前用户的待办和被驳回的流程数量汇总熔断");
      }
    };
  }
}
