package com.biz.crm.workflow.config;

import com.biz.crm.workflow.local.service.process.group.EventProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.group.GatewayProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.group.OtherProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.group.TaskProcessNodeGroup;
import com.biz.crm.workflow.local.strategy.button.ApproveProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.AssigneeProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.CommunicationProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.CopySendProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.CountersignProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.RejectProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.RollbackProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.button.UploadProcessButtonStrategy;
import com.biz.crm.workflow.local.strategy.delegatetype.LoginProcessDelegateTypeStrategy;
import com.biz.crm.workflow.local.strategy.delegatemandatarytype.OrgProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.local.strategy.delegatemandatarytype.UserProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.local.strategy.delegatetype.UserProcessDelegateTypeStrategy;
import com.biz.crm.workflow.local.strategy.extensionfield.TerminalProcessExtensionFieldStrategy;
import com.biz.crm.workflow.local.strategy.indicator.ApplicantProcessIndicatorStrategy;
import com.biz.crm.workflow.local.strategy.indicator.OrgProcessIndicatorStrategy;
import com.biz.crm.workflow.local.strategy.scope.OrgApplicationUserScopeStrategy;
import com.biz.crm.workflow.local.strategy.scope.OrgLevelApplicationUserScopeStrategy;
import com.biz.crm.workflow.local.strategy.scope.PositionApplicationUserScopeStrategy;
import com.biz.crm.workflow.local.strategy.scope.PositionLevelApplicationUserScopeStrategy;
import com.biz.crm.workflow.local.strategy.sms.sms.AliyunSmsStrategy;
import com.biz.crm.workflow.local.strategy.sms.smstouser.CustomerSmsToUserStrategy;
import com.biz.crm.workflow.local.strategy.sms.smstouser.PhoneSmsToUserStrategy;
import com.biz.crm.workflow.local.strategy.sms.smstouser.UserSmsToUserStrategy;
import com.biz.crm.workflow.local.strategy.tracing.OrgTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.PositionLevelTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.PositionTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.PreNodeApproverUpperTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.RoleTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.SponsorOrgLowerTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.SponsorOrgTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.SponsorOrgUpperTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.SponsorPositionLowerTracingStrategy;
import com.biz.crm.workflow.local.strategy.tracing.SponsorPositionUpperTracingStrategy;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.process.ProcessNodeGroup;
import com.biz.crm.workflow.sdk.strategy.button.ProcessButtonStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.extensionfield.ProcessExtensionFieldStrategy;
import com.biz.crm.workflow.sdk.strategy.indicator.ProcessIndicatorStrategy;
import com.biz.crm.workflow.sdk.strategy.scope.ApplicationUserScopeStrategy;
import com.biz.crm.workflow.sdk.strategy.sms.SmsStrategy;
import com.biz.crm.workflow.sdk.strategy.sms.SmsToUserStrategy;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * 描述：</br>默认实现的流程引擎配置注册信息
 *
 * @author keller
 * @date 2022/7/27
 */
@Component
public class ProcessTemplateLocalRegister implements ProcessTemplateRegister {

  /**
   * 流程发起可见范围
   * 默认实现注册：
   * 1、OrgApplicationUserScopeStrategy-通过组织可见
   * 2、OrgLevelApplicationUserScopeStrategy-通过组织层级可见
   * 3、PositionApplicationUserScopeStrategy-通过岗位可见
   * 4、PositionLevelApplicationUserScopeStrategy-通过岗位层级可见
   *
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ApplicationUserScopeStrategy>> getApplicationUserScopeStrategies() {
    return Sets.newHashSet(OrgApplicationUserScopeStrategy.class, OrgLevelApplicationUserScopeStrategy.class, PositionApplicationUserScopeStrategy.class, PositionLevelApplicationUserScopeStrategy.class);
  }

  /**
   * 流程审批可用按钮
   * 提供用户任务审批时候的操作按钮
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ProcessButtonStrategy>> getProcessButtonStrategies() {
    return Sets.newHashSet(ApproveProcessButtonStrategy.class, AssigneeProcessButtonStrategy.class, CommunicationProcessButtonStrategy.class, CopySendProcessButtonStrategy.class
            , CountersignProcessButtonStrategy.class, RejectProcessButtonStrategy.class, RollbackProcessButtonStrategy.class, UploadProcessButtonStrategy.class
    );
  }

  /**
   * 流程节点分组信息
   * 提供流程绘制上的组建分组信息具体分组中的按钮查看{@link com.biz.crm.workflow.config.ProcessTemplateNodeGroupRegister}
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ProcessNodeGroup>> getProcessNodeGroups() {
    return Lists.newArrayList(EventProcessNodeGroup.class, TaskProcessNodeGroup.class, GatewayProcessNodeGroup.class, OtherProcessNodeGroup.class);
  }

  /**
   * 用户任务审批人
   * 提供支持用户任务审批人的查询
   *
   * @return
   */
  @Override
  public Collection<Class<? extends TracingStrategy>> getTracingStrategies() {
    return Lists.newArrayList(OrgTracingStrategy.class, PositionTracingStrategy.class, RoleTracingStrategy.class, PositionLevelTracingStrategy.class, SponsorOrgTracingStrategy.class, SponsorOrgUpperTracingStrategy.class, SponsorOrgLowerTracingStrategy.class, SponsorPositionUpperTracingStrategy.class, SponsorPositionLowerTracingStrategy.class, PreNodeApproverUpperTracingStrategy.class);
  }

  /**
   * 流程指标策略
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ProcessIndicatorStrategy>> getProcessIndicatorStrategies() {
    return Lists.newArrayList(ApplicantProcessIndicatorStrategy.class, OrgProcessIndicatorStrategy.class);
  }

  /**
   * 流程扩展字段策略
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ProcessExtensionFieldStrategy>> getProcessExtensionFieldStrategies() {
//    return Lists.newArrayList(TerminalProcessExtensionFieldStrategy.class);
    return Lists.newArrayList();
  }

  /**
   * 短信平台策略
   *
   * @return
   */
  @Override
  public Class<? extends SmsStrategy> getSmsStrategyStrategies() {
    return AliyunSmsStrategy.class;
  }

  /**
   * 短信平台收件人策略
   *
   * @return
   */
  @Override
  public Collection<Class<? extends SmsToUserStrategy>> getSmsToUserStrategies() {
    return Lists.newArrayList(CustomerSmsToUserStrategy.class, PhoneSmsToUserStrategy.class, UserSmsToUserStrategy.class);
  }

  /**
   * 委托人策略接口策略
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ProcessDelegateTypeStrategy>> getProcessDelegateTypeStrategies() {
    return Lists.newArrayList(LoginProcessDelegateTypeStrategy.class, UserProcessDelegateTypeStrategy.class);
  }

  /**
   * 委托人策略接口策略
   *
   * @return
   */
  @Override
  public Collection<Class<? extends ProcessDelegateMandataryTypeStrategy>> getProcessDelegateMandataryTypeStrategies() {
    return Lists.newArrayList(OrgProcessDelegateMandataryTypeStrategy.class, UserProcessDelegateMandataryTypeStrategy.class);
  }
}
