package com.biz.crm.workflow.config;

import com.biz.crm.workflow.local.service.process.group.EventProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.group.GatewayProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.group.OtherProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.group.TaskProcessNodeGroup;
import com.biz.crm.workflow.local.service.process.node.event.EndProcessNode;
import com.biz.crm.workflow.local.service.process.node.event.StartProcessNode;
import com.biz.crm.workflow.local.service.process.node.gateway.ExclusiveGatewayProcessNode;
import com.biz.crm.workflow.local.service.process.node.gateway.InclusiveGatewayProcessNode;
import com.biz.crm.workflow.local.service.process.node.other.SequenceProcessNode;
import com.biz.crm.workflow.local.service.process.node.other.TextAnnotationProcessNode;
import com.biz.crm.workflow.local.service.process.node.task.EmailProcessNode;
import com.biz.crm.workflow.local.service.process.node.task.SmsProcessNode;
import com.biz.crm.workflow.local.service.process.node.task.UserTaskProcessNode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 描述：</br>注册的流程引擎流程节点分组信息
 *
 * @author keller
 * @date 2022/7/27
 */
@Configuration
public class ProcessTemplateNodeGroupRegister {

  @Bean
  public EventProcessNodeGroup getEventProcessNodeGroup() {
    return new EventProcessNodeGroup(StartProcessNode.class, EndProcessNode.class);
  }

  @Bean
  public TaskProcessNodeGroup getTaskProcessNodeGroup() {
    return new TaskProcessNodeGroup(UserTaskProcessNode.class, EmailProcessNode.class, SmsProcessNode.class);
  }

  @Bean
  public GatewayProcessNodeGroup getGatewayProcessNodeGroup() {
    return new GatewayProcessNodeGroup(ExclusiveGatewayProcessNode.class, InclusiveGatewayProcessNode.class);
  }

  @Bean
  public OtherProcessNodeGroup getOtherProcessNodeGroup() {
    return new OtherProcessNodeGroup(SequenceProcessNode.class, TextAnnotationProcessNode.class);
  }


}
