package com.biz.crm.workflow.sdk.constant;

import lombok.experimental.UtilityClass;

/**
 * 推送OA 流程通用参数
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.3.11 22:49
 */
@UtilityClass
public class OaConstant {


    /**
     * OA PC端接口
     */
    public final static String OA_PC_URL = "/backlog_external";

    /**
     * OA PC端任务回调接口
     */
    public final static String OA_PC_TASK_CALLBACK_URL = "/sended_external";

    /**
     * OA 移动端接口
     */
    public final static String OA_MOBILE_URL = "/pages/backlog_external";

    /**
     * OA 移动端任务回调接口
     */
    public final static String OA_MOBILE_TASK_CALLBACK_URL = "/pages/sended_external";

    /**
     * 推送OA失败,但   是正常的错误信息集合 英文逗号隔开
     */
    public final static String OA_SUCCESS_ERROR_MSG = "找不到对应的 wf_task,未经授权的请求";

    /**
     * 推送OA异常时,最大重试尝试次数
     */
    public final static Integer OA_SEND_MAX_TIME = 6;

    /**
     * OA推送MQ的tag
     */
    public final static String BPM_OA_SEND_RETRY_TAG = "BPM_OA_SEND_RETRY_TAG";

}
