package com.biz.crm.workflow.sdk.constant.enums;

import java.util.HashSet;
import java.util.Set;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 从202208版本开始弃用该枚举，最新枚举请查看{@link com.biz.crm.workflow.sdk.enums.ProcessStatusEnum}
 * @description: 审批状态
 * @author: rentao
 * @date: 2022/8/1 11:21
 */
@Getter
@Deprecated
public enum ActApproveStatusEnum {
  CREATE("create", "0", "待提交"),
  APPROVING("approving", "1", "审批中"),
  APPROVED("approved", "2", "审批通过"),
  REJECTED("rejected", "3", "审批驳回"),
  INTERRUPT("interrupt", "4", "流程追回"),
  CLOSED("closed", "5", "活动关闭");

  private final String key;
  private final String code;
  private final String des;

  ActApproveStatusEnum(String key, String code, String des) {
    this.code = code;
    this.des = des;
    this.key = key;
  }

  public String getCode() {
    return this.code;
  }

  public String getDes() {
    return this.des;
  }

  public static String getStatusName(String code) {
    ActApproveStatusEnum[] values = values();
    String desc = null;
    ActApproveStatusEnum[] var3 = values;
    int var4 = values.length;

    for(int var5 = 0; var5 < var4; ++var5) {
      ActApproveStatusEnum o = var3[var5];
      if (StringUtils.equals(o.getCode(), code)) {
        desc = o.getDes();
        break;
      }
    }

    return desc;
  }

  public static Set<String> getCanApproveStatus() {
    Set<String> set = new HashSet();
    set.add(CREATE.code);
    set.add(REJECTED.code);
    set.add(INTERRUPT.code);
    return set;
  }

  public static Set<String> getCanUpdateStatus() {
    Set<String> set = new HashSet();
    set.add(CREATE.code);
    set.add(REJECTED.code);
    set.add(INTERRUPT.code);
    return set;
  }
}
