package com.biz.crm.workflow.sdk.constant.enums;

import java.util.Objects;

/**
 * @author jerry7
 * 流程实例状态(启用,禁用,暂停,结束)
 */
public enum ProcessInstanceStatusEnum {
    ENABLE("enable","启用"),
    DISABLE("disable","禁用"),
    PAUSE("pause","暂停"),
    END("end","结束"),
            ;

    private final String code;
    private final String desc;

    ProcessInstanceStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    /**
     *根据编码返回流程状态名称
     * @param code
     * @return
     */
    public static String getStatusNameByCode(String code) {
        if(Objects.nonNull(code)){
            ProcessInstanceStatusEnum[] values = ProcessInstanceStatusEnum.values();
            for (ProcessInstanceStatusEnum statusEnum : values){
                if(statusEnum.getCode().equals(code)){
                    return statusEnum.getDesc();
                }
            }
        }
        return null;
    }
    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
