package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 蒙牛关联流程实例dto
 *
 * @author liuyifan
 * @date 2023-02-06 12:50:44
 */
@Data
@ApiModel(value = "BpmMnProcessCorrelationDto", description = "蒙牛关联流程实例dto")
public class BpmMnProcessCorrelationDto extends TenantFlagOpDto {

    /** 流程执行状态 */
    @ApiModelProperty(name = "processStatus",notes = "流程实例状态", value= "流程实例状态")
    private String processStatus;

    /** 流程KEY */
    @ApiModelProperty(name = "processKey",notes = "流程名称", value= "流程key")
    private String processKey;

    /** 流程名称 */
    @ApiModelProperty(name = "processName",notes = "流程名称", value= "流程名称")
    private String processName;

    /** 流程标题 */
    @ApiModelProperty(name = "processTitle",notes = "流程标题", value= "流程标题")
    private String processTitle;


    /** 里程实例id */
    @ApiModelProperty(name = "processInstanceId",notes = "流程实例id", value= "流程实例id")
    private String processInstanceId;

    /** 文件名称 */
    @ApiModelProperty(name = "mnInstanceId",notes = "蒙牛实例ID", value= "蒙牛实例ID")
    private String mnInstanceId;
}
