package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.workflow.sdk.enums.MnOaMethodEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.flowable.task.api.Task;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OaEventDto {

    /**
     * 任务
     */
    private Task task;

    /**
     * 处理程序用户编码
     */
    private String handlerUserCode;

    /**
     * 过程用户编码
     */
    private String processUserCode;

    /**
     * 流程实例id
     */
    private String processInstanceId;

    /**
     * 进程状态
     */
    private String processStatus;

    /**
     * 流程标题
     */
    private String processTitle;

    /**
     * oa任务类型
     */
    private Integer oaTaskType;

    /**
     * 办公自动化过程结果
     */
    private String oaProcessResult;

    /**
     * mn oa方法枚举
     */
    private MnOaMethodEnum mnOaMethodEnum;

    /**
     * url
     */
    private String url;

    /**
     * 任务url
     */
    private String taskUrl;

    /**
     * 移动审批url
     */
    private String mobileUrl;

    /**
     * 任务url
     */
    private String mobileTaskUrl;

    /**
     * 推送OA次数
     */
    private Integer sendTime = 1;
}
