package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import java.util.List;

/**
 * 组织信息事件DTO
 *
 * @author jerry7
 * @date 2021/12/23 15:12
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OrgInfoDto implements NebulaEventDto {

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织类型")
  private String orgType;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 组织编码列表
   */
  @ApiModelProperty("组织编码列表")
  private List<String> orgCodes;

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int page;

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int size;

}
