package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import java.util.List;

/**
 * 组织信息事件DTO
 *
 * @author jerry7
 * @date 2021/12/23 15:12
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PositionInfoDto implements NebulaEventDto {

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int page;

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int size;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 关联用户名称
   */
  @ApiModelProperty("关联用户名称")
  private String userName;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 组织编码
   */
  @ApiModelProperty("角色编码集合")
  private List<String> roleCodes;

  /**
   * 职位编码集合
   */
  @ApiModelProperty("职位编码集合")
  private List<String> positionCodes;

  /**
   * 职位id集合
   */
  @ApiModelProperty("职位id集合")
  private List<String> ids;
}
