package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 参数传递dto：流程待办列表DTO
 * @author : jerry7
 * @date : 2022-09-20
 */
@Getter
@Setter
public class ProcessTaskListDto extends TenantDto {
  /** 流程名称 */
  @ApiModelProperty(name = "processName",notes = "流程名称", value = "流程名称")
  private String processName;
  /** 流程标题 */
  @ApiModelProperty(name = "processTitle",notes = "流程标题", value = "流程标题")
  private String processTitle;
  /** 发起用户编码 */
  @ApiModelProperty(name = "userAccount",notes = "用户账号", value = "用户账号")
  private String userAccount;
  /** 租户编码 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编码", value = "租户编码")
  private String tenantCode;
  /**
   * 发起时间开始
   */
  @ApiModelProperty(name = "commitTimeStart", value = "发起时间开始")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date commitTimeStart;
  /**
   * 发起时间结束
   */
  @ApiModelProperty(name = "commitTimeEnd", value = "发起时间结束")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date commitTimeEnd;
  /** 发起用户名称*/
  @ApiModelProperty(name = "createName",notes = "用户名称", value = "用户名称")
  private String createName;
  /** 流程状态*/
  @ApiModelProperty(name = "processStatus",notes = "流程状态", value = "流程状态")
  private String processStatus;
  /** 业务表单编号*/
  @ApiModelProperty(name = "businessFormCode",notes = "业务表单编号", value = "业务表单编号")
  private String businessFormCode;
}
