package com.biz.crm.workflow.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 参数传递dto：流程节点代理人参数;
 * @author : Keller
 * @date : 2022-8-1
 */
@ApiModel(value = "ProcessTemplateNodeAssigneeVar",description = "流程节点代理人参数")
@Getter
@Setter
public class ProcessTemplateNodeAssigneeVarDto implements Serializable{
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value = "主键")
  private String id;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime",notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /** 创建人账号 */
  @ApiModelProperty(name = "createAccount",notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /** 创建人名称 */
  @ApiModelProperty(name = "createName",notes = "创建人名称", value = "创建人名称")
  private String createName;
  /** 修改人名称 */
  @ApiModelProperty(name = "modifyName",notes = "修改人名称", value= "修改人名称")
  private String modifyName;
  /** 修改人账号 */
  @ApiModelProperty(name = "modifyAccount",notes = "修改人账号", value= "修改人账号")
  private String modifyAccount;
  /** 修改时间 */
  @ApiModelProperty(name = "modifyTime",notes = "修改时间", value= "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /** 节点代理人id */
  @ApiModelProperty(name = "nodeAssigneeId",notes = "node_assignee_id", value = "node_assignee_id")
  private String nodeAssigneeId;
  /** 编号 */
  @ApiModelProperty(name = "code",notes = "编号", value = "编号")
  private String code;
  /** 名称 */
  @ApiModelProperty(name = "name",notes = "名称", value = "名称")
  private String name;
  /** 排序 */
  @ApiModelProperty(name = "sort",notes = "排序", value = "排序")
  private Integer sort;

}
