package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import lombok.Getter;
import lombok.Setter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 参数传递dto：流程待办委托;
 *
 * @author : jerry7
 * @date : 2022-8-30
 */
@ApiModel(value = "ProcessTodoDelegateDto", description = "流程待办委托")
@Getter
@Setter
public class ProcessTodoDelegateDto extends TenantFlagOpDto {

  /**
   * 主键
   */
  @ApiModelProperty(name = "id", notes = "主键", value = "主键")
  private String id;

  /**
   * 开始时间
   */
  @ApiModelProperty(name = "startTime", notes = "开始时间", value = "开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 流程实例id
   */
  @ApiModelProperty(name = "endTime", notes = "结束时间", value = "结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 委托类型
   */
  @ApiModelProperty(name = "delegateType", notes = "委托类型", value = "委托类型")
  private String delegateType;

  /**
   * 委托人
   */
  @ApiModelProperty(name = "user_name", notes = "委托人", value = "委托人")
  private String userName;


  /**
   * 委托人
   */
  @ApiModelProperty(name = "user_type", notes = "委托人类型", value = "委托人类型")
  private String userType;

  /**
   * 委托详情
   */
  @ApiModelProperty(value = "被委托人列表")
  private List<ProcessTodoDelegateDetailDto> detailDtoList;

}