package com.biz.crm.workflow.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 描述：</br>任务处理参数dto
 *
 * @author keller
 * @date 2022/8/4
 */
@ApiModel(value = "TaskDto",description = "任务处理参数dto")
@Getter
@Setter
public class TaskDto implements Serializable{

  /** 流程实例编号 */
  @ApiModelProperty(name = "processInstanceId",notes = "流程实例编号", value = "流程实例编号")
  private String processInstanceId;

  /** 任务编号 */
  @ApiModelProperty(name = "taskId",notes = "任务编号", value = "任务编号")
  private String taskId;

  /** 任务key */
  @ApiModelProperty(name = "taskDefinitionKey",notes = "任务key", value = "任务key")
  private String taskDefinitionKey;

  /** 模板编号 */
  @ApiModelProperty(name = "templateId",notes = "模板编号", value = "模板编号")
  private String templateId;

  /** 操作内容 */
  @ApiModelProperty(name = "content",notes = "操作内容", value = "操作内容")
  private String content;

  /** 岗位编码 */
  @ApiModelProperty(name = "positionCode",notes = "岗位编码", value = "岗位编码")
  private String positionCode;

  /** 按钮编码 */
  @ApiModelProperty(name = "processButtonCode",notes = "按钮编码", value = "按钮编码")
  private String processButtonCode;

  /** 要回退的任务 */
  @ApiModelProperty(name = "targetKey",notes = "要回退的任务", value = "要回退的任务")
  private String targetKey;

  /** 目标账号 */
  @ApiModelProperty(name = "targetUserName",notes = "目标账号", value = "目标账号")
  private String targetUserName;

  /** 修改表单数据标识 */
  @ApiModelProperty(name = "editFormData",notes = "修改表单数据标识", value = "修改表单数据标识")
  private Boolean editFormData;

  /** 修改表单数据 */
  @ApiModelProperty(name = "formDataJson",notes = "修改表单数据", value = "修改表单数据")
  private String formDataJson;

  /** 沟通内容 */
  @ApiModelProperty(name = "communicationContent",notes = "发起沟通内容", value = "发起沟通内容")
  private String communicationContent;

  /** 上传文件信息 */
  @ApiModelProperty(name = "processInstanceFiles",notes = "上传文件信息", value = "上传文件信息")
  private List<ProcessInstanceFilesDto> processInstanceFiles;

  @ApiModelProperty(name = " positionCodes",notes = "加签选择职位编码列表", value = "加签选择职位编码列表")
  private List<String> positionCodes;

  /** 是否确认沟通后才能审批 */
  @ApiModelProperty(name = "needComplete",notes = "是否确认沟通后才能审批", value= "是否确认沟通后才能审批")
  private String needComplete;

  /** 执行id */
  @ApiModelProperty(name = "executionId",notes = "执行id", value= "执行id")
  private String executionId;

}
