package com.biz.crm.workflow.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 委托人枚举
 * @author : rentao
 * @date : 2022/11/23 15:33
 */
@Getter
@AllArgsConstructor
public enum DelegatePersonTypeEnum {

  /**
   * 登录人委托
   */
  PERSON_LOGIN("person_login", "PERSON_LOGIN", "登录人委托", "1"),

  /**
   * 其他人委托
   */
  PERSON_OTHER("person_login", "person_login", "其他人委托", "2");

  /**
   * 系统key
   */
  private final String key;
  /**
   * 字典编码
   */
  private final String dictCode;
  /**
   * 字典值
   */
  private final String value;
  /**
   * 字典排序
   */
  private final String order;

}
