package com.biz.crm.workflow.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:工作流 流程生效范围
 * @author: rentao
 * @date: 2022/7/25 15:12
 */
@Getter
@AllArgsConstructor
public enum EffectiveScopeEnum {

  /**
   * 仅PC端可用
   */
  PC("PC", "PC", "仅PC端可用", "1"),

  /**
   * 仅移动端可用
   */
  MOBILE("MOBILE", "MOBILE", "仅移动端可用", "2"),

  /**
   * 都可用
   */
  ALL("ALL", "ALL", "都可用", "3");

  /**
   * 系统key
   */
  private final String key;
  /**
   * 字典编码
   */
  private final String dictCode;
  /**
   * 字典值
   */
  private final String value;
  /**
   * 字典排序
   */
  private final String order;


}
