package com.biz.crm.workflow.sdk.enums;

import java.util.Objects;

/**
 * 流程状态枚举
 *
 * @author jerry7
 */
public enum IsPushOaEnum {
  PUSH("1", "推送"),
  NO_PUSH("0", "不推送"),

  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;


  IsPushOaEnum(String key, String dictCode) {
    this.key = key;
    this.dictCode = dictCode;
  }


  /**
   * 根据编码校验状态值是否存在
   *
   * @param key
   * @return
   */
  public static boolean checkKeyExist(String key) {

    IsPushOaEnum[] values = IsPushOaEnum.values();
    for (IsPushOaEnum statusEnum : values) {
      if (statusEnum.getKey().equals(key)) {
        return true;
      }
    }
    return false;
  }

  /**
   * 根据编码返回流程状态enum
   *
   * @param key
   * @return
   */
  public static IsPushOaEnum getStatusEnumByDictCode(String key) {
    if (Objects.nonNull(key)) {
      IsPushOaEnum[] values = IsPushOaEnum.values();
      for (IsPushOaEnum statusEnum : values) {
        if (statusEnum.getKey().equals(key)) {
          return statusEnum;
        }
      }
    }
    return null;
  }


  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

}
