package com.biz.crm.workflow.sdk.enums;

import java.util.Objects;

/**
 * 流程状态枚举
 *
 * @author jerry7
 */
public enum MnOaMethodEnum {
  START_PROCESS("start_process", "开启流程"),
  END_PROCESS("end_process", "结束流程"),
  START_TASK("start_task", "创建任务" ),
  PROCESS_TASK("process_task", "处理任务"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;


  MnOaMethodEnum(String key, String dictCode) {
    this.key = key;
    this.dictCode = dictCode;
  }


  /**
   * 根据编码校验状态值是否存在
   *
   * @param key
   * @return
   */
  public static boolean checkKeyExist(String key) {

    MnOaMethodEnum[] values = MnOaMethodEnum.values();
    for (MnOaMethodEnum statusEnum : values) {
      if (statusEnum.getKey().equals(key)) {
        return true;
      }
    }
    return false;
  }

  /**
   * 根据编码返回流程状态enum
   *
   * @param key
   * @return
   */
  public static MnOaMethodEnum getStatusEnumByDictCode(String key) {
    if (Objects.nonNull(key)) {
      MnOaMethodEnum[] values = MnOaMethodEnum.values();
      for (MnOaMethodEnum statusEnum : values) {
        if (statusEnum.getKey().equals(key)) {
          return statusEnum;
        }
      }
    }
    return null;
  }


  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

}
