package com.biz.crm.workflow.sdk.enums;

import java.util.Objects;

/**
 * 流程状态枚举
 *
 * @author jerry7
 */
public enum OaCallbackViewEnum {
  SENDED_EXTERNAL("sended_external", "已办页面"),
  BACKLOG_EXTERNAL("backlog_external", "待办页面"),

  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;


  OaCallbackViewEnum(String key, String dictCode) {
    this.key = key;
    this.dictCode = dictCode;
  }


  /**
   * 根据编码校验状态值是否存在
   *
   * @param key
   * @return
   */
  public static boolean checkKeyExist(String key) {

    OaCallbackViewEnum[] values = OaCallbackViewEnum.values();
    for (OaCallbackViewEnum statusEnum : values) {
      if (statusEnum.getKey().equals(key)) {
        return true;
      }
    }
    return false;
  }

  /**
   * 根据编码返回流程状态enum
   *
   * @param key
   * @return
   */
  public static OaCallbackViewEnum getStatusEnumByDictCode(String key) {
    if (Objects.nonNull(key)) {
      OaCallbackViewEnum[] values = OaCallbackViewEnum.values();
      for (OaCallbackViewEnum statusEnum : values) {
        if (statusEnum.getKey().equals(key)) {
          return statusEnum;
        }
      }
    }
    return null;
  }


  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

}
