package com.biz.crm.workflow.sdk.event;

import com.biz.crm.workflow.sdk.vo.BpmMnProcessCorrelationVo;
import java.util.List;

/**
 * 蒙牛关联流程实例变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-06 12:50:45
 */
public interface BpmMnProcessCorrelationEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(BpmMnProcessCorrelationVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(BpmMnProcessCorrelationVo oldVo, BpmMnProcessCorrelationVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<BpmMnProcessCorrelationVo> list);

    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<BpmMnProcessCorrelationVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<BpmMnProcessCorrelationVo> list);
}
