package com.biz.crm.workflow.sdk.event;

import com.biz.crm.workflow.sdk.vo.BpmMnProcessTaskCorrelationVo;
import java.util.List;

/**
 * 蒙牛关联流程任务实例变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-06 17:26:02
 */
public interface BpmMnProcessTaskCorrelationEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(BpmMnProcessTaskCorrelationVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(BpmMnProcessTaskCorrelationVo oldVo, BpmMnProcessTaskCorrelationVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<BpmMnProcessTaskCorrelationVo> list);

    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<BpmMnProcessTaskCorrelationVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<BpmMnProcessTaskCorrelationVo> list);
}
